/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    protected static final Logger LOGGER = LoggerFactory.getLogger(JsonUtil.class);

    private JsonUtil() {
    }

    public static Map<String, Object> getMap(ObjectNode jsonNode) {
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.convertValue((Object)jsonNode, Map.class);
        return result;
    }

    public static String getString(JSONObject obj, String key, String defaultValue) {
        if (obj == null || !obj.containsKey((Object)key)) {
            return defaultValue;
        }
        return obj.getString(key);
    }

    public static String getString(JSONObject obj, String key) {
        return JsonUtil.getString(obj, key, "");
    }

    public static int getInt(JSONObject obj, String key) {
        if (obj == null || !obj.containsKey((Object)key)) {
            return 0;
        }
        return obj.getIntValue(key);
    }

    public static int getInt(JSONObject obj, String key, int defaultValue) {
        if (obj == null || !obj.containsKey((Object)key)) {
            return defaultValue;
        }
        return obj.getIntValue(key);
    }

    public static boolean getBoolean(JSONObject obj, String key) {
        if (obj == null || !obj.containsKey((Object)key)) {
            return false;
        }
        return obj.getBoolean(key);
    }

    public static boolean getBoolean(JSONObject obj, String key, boolean defaultValue) {
        if (obj == null || !obj.containsKey((Object)key)) {
            return defaultValue;
        }
        return obj.getBoolean(key);
    }

    public static <T> T parseObject(String jsonStr, Class<T> cls) {
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return null;
        }
        return (T)JSON.parseObject((String)jsonStr, cls);
    }

    public static <T> List<T> parseArray(String jsonStr, Class<T> cls) {
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return Collections.emptyList();
        }
        return JSON.parseArray((String)jsonStr, cls);
    }

    public static String toJSONString(Object obj) {
        if (obj == null) {
            return null;
        }
        return JSON.toJSONString((Object)obj);
    }
}

