/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils;

import com.pangubpm.common.utils.Exp;
import java.util.Map;
import java.util.Objects;

class VarExp
extends Exp {
    private String varName;
    private String defaultValue;
    private Boolean nullable = false;

    VarExp(String varName, String defaultValue, Boolean nullable) {
        this.varName = varName;
        this.defaultValue = defaultValue;
        this.nullable = nullable;
    }

    VarExp(String exp) {
        Objects.requireNonNull(exp);
        if (!exp.startsWith("#{") && !exp.startsWith("${") || !exp.endsWith("}")) {
            throw new IllegalArgumentException("\u8868\u8fbe\u5f0f[" + exp + "]\u5fc5\u987b\u7c7b\u4f3c\u4e8e#{}\u6216${}");
        }
        String[] nodes = exp.substring(2, exp.length() - 1).split(",");
        if (nodes.length > 2) {
            throw new IllegalArgumentException("\u8868\u8fbe\u5f0f[" + exp + "]\u53ea\u80fd\u51fa\u73b0\u4e00\u4e2a','");
        }
        this.varName = nodes[0].trim();
        this.defaultValue = nodes.length == 2 ? nodes[1].trim() : "";
        this.nullable = exp.startsWith("$");
    }

    @Override
    public String resolve(Map<String, String> context) {
        String value = context.get(this.varName);
        if (value == null && this.nullable.booleanValue()) {
            String string = value = this.defaultValue == null ? "" : this.defaultValue;
        }
        if (value == null) {
            throw new NullPointerException("\u4e0a\u4e0b\u6587\u4e2d\u6ca1\u6709\u6307\u5b9a\u7684\u53d8\u91cf:var=" + this.varName + " map=" + context);
        }
        return value;
    }

    public String toString() {
        return "VarExp [varName=" + this.varName + ", defaultValue=" + this.defaultValue + ", nullable=" + this.nullable + "]";
    }
}

