/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.db.utils;

import com.pangubpm.common.db.exception.DBException;
import com.pangubpm.common.db.operate.DbTypeOperate;
import com.pangubpm.common.db.util.FreemarkerUtils;
import com.pangubpm.common.db.util.oConvertUtils;
import com.pangubpm.common.utils.BpmSpringContextUtils;
import com.pangubpm.modules.db.entity.CgformConfigModel;
import com.pangubpm.modules.db.entity.ColumnMeta;
import com.pangubpm.modules.db.entity.FormDataBaseConfig;
import com.pangubpm.modules.db.service.DbTableHandle;
import com.pangubpm.modules.db.service.impl.MysqlHandleImpl;
import com.pangubpm.modules.form.entity.FormBusinessModelColumnEntity;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTableProcess {
    private static final Logger logger = LoggerFactory.getLogger(oConvertUtils.class);
    private static final String tpl_url = "config/engine/tableTemplate.ftl";
    private DbTableHandle dbTableHandle;

    public DbTableProcess() throws SQLException, DBException {
        String databaseType;
        switch (databaseType = DbTypeOperate.getDatabaseType()) {
            case "mysql": {
                this.dbTableHandle = new MysqlHandleImpl();
                break;
            }
        }
    }

    public DbTableHandle getDbTableHandle() {
        return this.dbTableHandle;
    }

    public static void createTable(CgformConfigModel model) throws IOException, TemplateException, HibernateException, SQLException, DBException {
        String dbType = DbTypeOperate.getDatabaseType();
        String xml = FreemarkerUtils.parseTemplate((String)tpl_url, DbTableProcess.getRootMap(model, dbType));
        System.out.println(xml);
        HashMap<String, Object> settings = new HashMap<String, Object>();
        FormDataBaseConfig dbconfig = model.getDbConfig();
        settings.put("hibernate.connection.driver_class", dbconfig.getDriverClassName());
        settings.put("hibernate.connection.url", dbconfig.getUrl());
        settings.put("hibernate.connection.username", dbconfig.getUsername());
        settings.put("hibernate.connection.password", dbconfig.getPassword());
        settings.put("hibernate.show_sql", true);
        settings.put("hibernate.format_sql", true);
        settings.put("hibernate.temp.use_jdbc_metadata_defaults", false);
        settings.put("hibernate.dialect", DbTypeOperate.getDialect((String)dbType));
        settings.put("hibernate.hbm2ddl.auto", "create");
        settings.put("hibernate.connection.autocommit", false);
        settings.put("hibernate.current_session_context_class", "thread");
        StandardServiceRegistry registry = new StandardServiceRegistryBuilder().applySettings(settings).build();
        MetadataSources ms = new MetadataSources((ServiceRegistry)registry);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xml.getBytes());
        ms.addInputStream((InputStream)xmlInputStream);
        Metadata metadata = ms.buildMetadata();
        SchemaExport dbExport = new SchemaExport();
        dbExport.create(EnumSet.of(TargetType.DATABASE), metadata);
        ((InputStream)xmlInputStream).close();
        List exceptionList = dbExport.getExceptions();
        for (Exception exception : exceptionList) {
            if ("java.sql.SQLSyntaxErrorException".equals(exception.getCause().getClass().getName())) {
                SQLSyntaxErrorException e = (SQLSyntaxErrorException)exception.getCause();
                if ("42000".equals(e.getSQLState())) {
                    if (1064 != e.getErrorCode() && 903 != e.getErrorCode()) continue;
                    throw new DBException("\u8bf7\u786e\u8ba4\u8868\u540d\u662f\u5426\u4e3a\u5173\u952e\u5b57\u3002");
                }
            } else if ("com.microsoft.sqlserver.jdbc.SQLServerException".equals(exception.getCause().getClass().getName())) {
                if (exception.getCause().toString().indexOf("Incorrect syntax near the keyword") != -1) {
                    exception.printStackTrace();
                    throw new DBException(exception.getCause().getMessage());
                }
                logger.error(exception.getMessage());
                continue;
            }
            throw new DBException(exception.getMessage());
        }
    }

    public List<String> updateTable(CgformConfigModel model) throws DBException, SQLException {
        String dataType = DbTypeOperate.getDatabaseType();
        String tableName = DbTypeOperate.getTableName((String)model.getTableName(), (String)dataType);
        String alterSql = "alter table  " + tableName + " ";
        ArrayList<String> alterList = new ArrayList<String>();
        try {
            Map<String, ColumnMeta> dbMetaCol = this.getDbMetaColumns(null, tableName);
            Map<String, ColumnMeta> configCol = this.getConfigColumns(model);
            Map<String, String> newAndOldFieldMap = this.getNewAndOldFieldName(model.getColumns());
            for (String columnName : configCol.keySet()) {
                ColumnMeta cgFormColumnMeta;
                if (!dbMetaCol.containsKey(columnName)) {
                    ColumnMeta cgFormColumnMeta2 = configCol.get(columnName);
                    String oldFieldName = newAndOldFieldMap.get(columnName);
                    if (newAndOldFieldMap.containsKey(columnName) && dbMetaCol.containsKey(oldFieldName)) {
                        ColumnMeta dataColumnMeta = dbMetaCol.get(oldFieldName);
                        String changeSql = this.dbTableHandle.getReNameFieldName(cgFormColumnMeta2);
                        if ("SQLSERVER".equals(dataType)) {
                            alterList.add(changeSql);
                        } else {
                            alterList.add(alterSql + changeSql);
                        }
                        String oldFieldSql = this.getUpdateOldFieldSql(columnName, cgFormColumnMeta2.getColumnId());
                        alterList.add(oldFieldSql);
                        if (!dataColumnMeta.equals(cgFormColumnMeta2)) {
                            alterList.add(alterSql + this.getUpdateColumnSql(cgFormColumnMeta2, dataColumnMeta));
                            if ("POSTGRESQL".equals(dataType)) {
                                alterList.add(alterSql + this.getUpdateSpecialSql(cgFormColumnMeta2, dataColumnMeta));
                            }
                        }
                        if ("SQLSERVER".equals(dataType) || dataColumnMeta.equalsComment(cgFormColumnMeta2)) continue;
                        alterList.add(this.getCommentSql(cgFormColumnMeta2));
                        continue;
                    }
                    alterList.add(alterSql + this.getAddColumnSql(cgFormColumnMeta2));
                    if ("SQLSERVER".equals(dataType) || !StringUtils.isNotEmpty((CharSequence)cgFormColumnMeta2.getComment())) continue;
                    alterList.add(this.getCommentSql(cgFormColumnMeta2));
                    continue;
                }
                ColumnMeta dataColumnMeta = dbMetaCol.get(columnName);
                if (!dataColumnMeta.equalsByDataType(cgFormColumnMeta = configCol.get(columnName), dataType)) {
                    alterList.add(alterSql + this.getUpdateColumnSql(cgFormColumnMeta, dataColumnMeta));
                }
                if ("SQLSERVER".equals(dataType) || "ORACLE".equals(dataType) || dataColumnMeta.equalsComment(cgFormColumnMeta)) continue;
                alterList.add(this.getCommentSql(cgFormColumnMeta));
            }
            for (String columnName : dbMetaCol.keySet()) {
                if (configCol.containsKey(columnName.toLowerCase()) || newAndOldFieldMap.containsValue(columnName.toLowerCase())) continue;
                alterList.add(alterSql + this.getDropColumnSql(columnName));
            }
        }
        catch (SQLException e1) {
            throw new RuntimeException();
        }
        logger.info(" db update sql : " + ((Object)alterList).toString());
        return alterList;
    }

    private static Map<String, Object> getRootMap(CgformConfigModel model, String dataType) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entity", model);
        map.put("dataType", dataType);
        return map;
    }

    private Map<String, ColumnMeta> getDbMetaColumns(String schemaName, String tableName) throws SQLException {
        HashMap<String, ColumnMeta> columnMap = new HashMap<String, ColumnMeta>();
        Connection conn = null;
        try {
            conn = DbTableProcess.getConnection();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        DatabaseMetaData dbMetaData = conn.getMetaData();
        FormDataBaseConfig dataBaseConfig = (FormDataBaseConfig)BpmSpringContextUtils.getApplicationContext().getBean(FormDataBaseConfig.class);
        String dataBaseType = null;
        dataBaseType = DbTypeOperate.getDatabaseType();
        String user = dataBaseConfig.getUsername();
        ResultSet rs = null;
        rs = dataBaseType.equalsIgnoreCase(DbTypeOperate.getDatabaseType()) ? dbMetaData.getColumns(conn.getCatalog(), null, tableName, "%") : dbMetaData.getColumns(conn.getCatalog(), user, tableName, "%");
        while (rs.next()) {
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setTableName(tableName);
            String columnName = rs.getString("COLUMN_NAME").toLowerCase();
            columnMeta.setColumnName(columnName);
            String typeName = rs.getString("TYPE_NAME");
            int decimalDigits = rs.getInt("DECIMAL_DIGITS");
            String colunmType = this.dbTableHandle.getMatchClassTypeByDataType(typeName, decimalDigits);
            columnMeta.setColunmType(colunmType);
            int columnSize = rs.getInt("COLUMN_SIZE");
            columnMeta.setColumnSize(columnSize);
            columnMeta.setDecimalDigits(decimalDigits);
            String isNullable = rs.getInt("NULLABLE") == 1 ? "Y" : "N";
            columnMeta.setIsNullable(isNullable);
            String comment = rs.getString("REMARKS");
            columnMeta.setComment(comment);
            String columnDef = rs.getString("COLUMN_DEF");
            String fieldDefault = DbTableProcess.judgeIsNumber(columnDef) == null ? "" : DbTableProcess.judgeIsNumber(columnDef);
            columnMeta.setFieldDefault(fieldDefault);
            logger.info("getColumnMetadataFormDataBase --->COLUMN_NAME:" + columnName.toUpperCase() + " TYPE_NAME :" + typeName + " DECIMAL_DIGITS:" + decimalDigits + " COLUMN_SIZE:" + columnSize);
            columnMap.put(columnName, columnMeta);
        }
        return columnMap;
    }

    private Map<String, ColumnMeta> getConfigColumns(CgformConfigModel model) {
        HashMap<String, ColumnMeta> columnMap = new HashMap<String, ColumnMeta>();
        List<FormBusinessModelColumnEntity> fieldList = model.getColumns();
        for (FormBusinessModelColumnEntity field : fieldList) {
            ColumnMeta columnMeta = new ColumnMeta();
            columnMeta.setTableName(model.getTableName().toLowerCase());
            columnMeta.setColumnId(field.getId());
            columnMeta.setColumnName(field.getColumnKey().toLowerCase());
            columnMeta.setColumnSize(field.getAttrLength());
            columnMeta.setColunmType(field.getDataType().toLowerCase());
            columnMeta.setComment(field.getDescription());
            columnMeta.setDecimalDigits(field.getDecimalLength());
            columnMeta.setFieldDefault(DbTableProcess.judgeIsNumber(field.getDefaultValue()));
            boolean required = field.isRequired();
            columnMeta.setIsNullable(required ? "N" : "Y");
            columnMap.put(field.getColumnKey().toLowerCase(), columnMeta);
        }
        return columnMap;
    }

    private Map<String, String> getNewAndOldFieldName(List<FormBusinessModelColumnEntity> fieldList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (FormBusinessModelColumnEntity field : fieldList) {
            map.put(field.getColumnKey(), field.getColumnKey());
        }
        return map;
    }

    private String getDropColumnSql(String fieldName) {
        return this.dbTableHandle.getDropColumnSql(fieldName);
    }

    private String getUpdateColumnSql(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) throws DBException {
        return this.dbTableHandle.getUpdateColumnSql(cgformcolumnMeta, datacolumnMeta);
    }

    private String getUpdateSpecialSql(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) {
        return this.dbTableHandle.getSpecialHandle(cgformcolumnMeta, datacolumnMeta);
    }

    private String getReNameFieldName(ColumnMeta columnMeta) {
        return this.dbTableHandle.getReNameFieldName(columnMeta);
    }

    private String getAddColumnSql(ColumnMeta columnMeta) {
        return this.dbTableHandle.getAddColumnSql(columnMeta);
    }

    private String getCommentSql(ColumnMeta columnMeta) {
        return this.dbTableHandle.getCommentSql(columnMeta);
    }

    private String getUpdateOldFieldSql(String columnName, String id) {
        return "update onl_cgform_field set DB_FIELD_NAME_OLD = '" + columnName + "' where ID ='" + id + "'";
    }

    private int updateFieldName(String columnName, String id, Session session) {
        return session.createSQLQuery("update onl_cgform_field set DB_FIELD_NAME_OLD= '" + columnName + "' where ID ='" + id + "'").executeUpdate();
    }

    private static String judgeIsNumber(String text) {
        block3: {
            if (StringUtils.isNotEmpty((CharSequence)text)) {
                try {
                    Double.valueOf(text);
                }
                catch (Exception e) {
                    if (text.startsWith("'") && text.endsWith("'")) break block3;
                    text = "'" + text + "'";
                }
            }
        }
        return text;
    }

    public String dropIndex(String indexName, String tableName) {
        return this.dbTableHandle.dropIndexs(indexName, tableName);
    }

    public String getCountIndexSql(String indexName, String tableName) {
        return this.dbTableHandle.countIndex(indexName, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getIndexInfo(String tbname) throws SQLException {
        Connection conn = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            conn = DbTableProcess.getConnection();
            DatabaseMetaData dbmd = conn.getMetaData();
            rs = dbmd.getIndexInfo(null, null, tbname, false, false);
            ResultSetMetaData md = rs.getMetaData();
            while (rs.next()) {
                String index_name = rs.getString("INDEX_NAME");
                if (oConvertUtils.isEmpty((Object)index_name)) {
                    index_name = rs.getString("index_name");
                }
                if (!oConvertUtils.isNotEmpty((Object)index_name)) continue;
                list.add(index_name);
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return list;
    }

    public static Connection getConnection() throws SQLException {
        DataSource dataSource = (DataSource)BpmSpringContextUtils.getApplicationContext().getBean(DataSource.class);
        return dataSource.getConnection();
    }
}

