/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.client.model;

import com.para.secure.client.BaseEntity;
import com.para.secure.client.OAuthClient;
import com.para.secure.exceptions.OAuthApiException;
import com.para.secure.model.Response;
import com.para.secure.model.Token;
import com.para.secure.utils.Json2ObjectUtil;
import com.para.secure.utils.OAuthConfigUtil;
import com.para.secure.utils.Preconditions;
import java.util.HashMap;

public class UserInfo
extends BaseEntity {
    private String id;
    private String linkId;
    private String classOrTeam;
    private String userName;
    private String gradeOrDept;
    private String userType;
    private Token accessToken;

    public UserInfo() {
    }

    public UserInfo(Token accessToken) {
        this.accessToken = accessToken;
    }

    public Token getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(Token accessToken) {
        this.accessToken = accessToken;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    public String getClassOrTeam() {
        return this.classOrTeam;
    }

    public void setClassOrTeam(String classOrTeam) {
        this.classOrTeam = classOrTeam;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getGradeOrDept() {
        return this.gradeOrDept;
    }

    public void setGradeOrDept(String gradeOrDept) {
        this.gradeOrDept = gradeOrDept;
    }

    public String getUserType() {
        return this.userType;
    }

    public void setUserType(String userType) {
        this.userType = userType;
    }

    public UserInfo requestUserInfo() throws OAuthApiException {
        Preconditions.checkNotNull(this.accessToken, "accessToken is null");
        OAuthClient client = new OAuthClient(OAuthConfigUtil.getUserInfoUrl());
        client.signAccessToken(this.accessToken);
        Response response = client.execute();
        UserInfo user = new UserInfo();
        System.out.println("response.getBody()>>>" + response.getBody());
        if (response.getBody() != null && !"".equals(response.getBody().trim())) {
            user = (UserInfo)Json2ObjectUtil.json2Object(response.getBody(), user);
        }
        if (user.getError() != null && !"".equals(user.getError().trim())) {
            throw new OAuthApiException(user.getError(), user.getError_description());
        }
        return user;
    }

    public String requestJsonUserInfo() throws OAuthApiException {
        Preconditions.checkNotNull(this.accessToken, "accessToken is null");
        OAuthClient client = new OAuthClient(OAuthConfigUtil.getUserInfoUrl());
        client.signAccessToken(this.accessToken);
        Response response = client.execute();
        UserInfo user = new UserInfo();
        System.out.println("response.getBody()>>>" + response.getBody());
        if (user.getError() != null && !"".equals(user.getError().trim())) {
            throw new OAuthApiException(user.getError(), user.getError_description());
        }
        return response.getBody();
    }

    public UserInfo getUserInfo() throws OAuthApiException {
        Preconditions.checkNotNull(this.accessToken, "accessToken is null");
        OAuthClient client = new OAuthClient(OAuthConfigUtil.getUserInfoUrl());
        client.signAccessToken(this.accessToken);
        Response response = client.execute();
        HashMap userMap = new HashMap();
        UserInfo user = new UserInfo();
        System.out.println("response.getBody()>>>" + response.getBody());
        if (response.getBody() != null && !"".equals(response.getBody().trim())) {
            userMap = (HashMap)Json2ObjectUtil.json2Object(response.getBody(), userMap);
            if (userMap.get("error") != null && !"".equals(userMap.get("error").toString().trim())) {
                throw new OAuthApiException("error", userMap.get("error").toString().trim());
            }
            user.setId(userMap.get("id").toString());
            String attributes = userMap.get("attributes").toString();
            attributes = attributes.replace("{", "\"").replace("=", "\":").replace("[", "\"").replace("]", "\"").replace("}", "");
            attributes = "{" + attributes.substring(1, attributes.length() - 1) + "}";
            userMap = (HashMap)Json2ObjectUtil.json2Object(attributes, userMap);
            user.setLinkId(userMap.get("linkId").toString());
            user.setUserName(userMap.get("userName").toString());
            user.setClassOrTeam(userMap.get("classOrTeam").toString());
            user.setGradeOrDept(userMap.get("gradeOrDept").toString());
            user.setUserType(userMap.get("userType").toString());
        }
        return user;
    }

    public String toString() {
        return "UserInfo [id=" + this.id + ", linkId=" + this.linkId + "]";
    }
}

