/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.extractors;

import com.para.secure.exceptions.OAuthException;
import com.para.secure.extractors.AccessTokenExtractor;
import com.para.secure.extractors.RequestTokenExtractor;
import com.para.secure.model.Token;
import com.para.secure.utils.OAuthEncoder;
import com.para.secure.utils.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TokenExtractorImpl
implements RequestTokenExtractor,
AccessTokenExtractor {
    private static final Pattern TOKEN_REGEX = Pattern.compile("oauth_token=([^&]+)");
    private static final Pattern SECRET_REGEX = Pattern.compile("oauth_token_secret=([^&]+)");

    @Override
    public Token extract(String response) {
        Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
        String token = this.extract(response, TOKEN_REGEX);
        String secret = this.extract(response, SECRET_REGEX);
        return new Token(token, secret, response);
    }

    private String extract(String response, Pattern p) {
        Matcher matcher = p.matcher(response);
        if (matcher.find() && matcher.groupCount() >= 1) {
            return OAuthEncoder.decode(matcher.group(1));
        }
        throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: '" + response + "'", null);
    }

    @Override
    public Token extractESCToken(String response) {
        Preconditions.checkEmptyString(response, "Response body is incorrect. Can't extract a token from an empty string");
        String token = this.extractESCToken(response, TOKEN_REGEX);
        String secret = this.extractESCToken(response, SECRET_REGEX);
        return new Token(token, secret, response);
    }

    private String extractESCToken(String response, Pattern p) {
        Matcher matcher = p.matcher(response);
        if (matcher.find() && matcher.groupCount() >= 1) {
            return OAuthEncoder.decode(matcher.group(1));
        }
        throw new OAuthException("Response body is incorrect. Can't extract token and secret from this: '" + response + "'", null);
    }
}

