/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.model;

import com.para.secure.utils.OAuthConfigUtil;
import com.para.secure.utils.Preconditions;

public class OAuth20Config {
    private String clientId;
    private String clientSerect;
    private String redirectUri;
    private String authorizeUrl;
    private String target_uri;
    private String accessTokenUrl;
    private String scope = "all";

    public OAuth20Config(String clientId, String clientSerect, String redirectUri) {
        this.clientId = clientId;
        this.clientSerect = clientSerect;
        this.redirectUri = redirectUri;
        this.authorizeUrl = OAuthConfigUtil.getAuthorizeUrl();
        this.accessTokenUrl = OAuthConfigUtil.getAccessTokenUrl();
        Preconditions.checkNotNull(clientId, "clientId cannot be null");
        Preconditions.checkNotNull(clientSerect, "clientSerect cannot be null");
        Preconditions.checkNotNull(redirectUri, "callback cannot be null");
    }

    public OAuth20Config(String clientId, String clientSerect, String redirectUri, String authorizeUrl, String accessTokenUrl) {
        this.clientId = clientId;
        this.clientSerect = clientSerect;
        this.redirectUri = redirectUri;
        this.authorizeUrl = authorizeUrl;
        this.accessTokenUrl = accessTokenUrl;
        Preconditions.checkNotNull(clientId, "clientId cannot be null");
        Preconditions.checkNotNull(clientSerect, "clientSerect cannot be null");
        Preconditions.checkNotNull(redirectUri, "callback cannot be null");
        Preconditions.checkNotNull(authorizeUrl, "authorizeUrl cannot be null");
        Preconditions.checkNotNull(accessTokenUrl, "accessTokenUrl cannot be null");
    }

    public OAuth20Config(String clientId, String clientSerect, String redirectUri, String authorizeUrl, String accessTokenUrl, String target_uri) {
        this(clientId, clientSerect, redirectUri, authorizeUrl, accessTokenUrl);
        if (target_uri == null || target_uri == "") {
            target_uri = "";
        }
        this.target_uri = target_uri;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSerect() {
        return this.clientSerect;
    }

    public void setClientSerect(String clientSerect) {
        this.clientSerect = clientSerect;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getAuthorizeUrl() {
        return this.authorizeUrl;
    }

    public void setAuthorizeUrl(String authorizeUrl) {
        this.authorizeUrl = authorizeUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String getTarget_uri() {
        return this.target_uri;
    }

    public void setTarget_uri(String target_uri) {
        this.target_uri = target_uri;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean hasScope() {
        return this.scope != null && !this.scope.equalsIgnoreCase("");
    }
}

