/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.model;

import com.para.secure.model.SignatureType;
import java.io.OutputStream;

public class OAuthConfig {
    private final String apiKey;
    private final String apiSecret;
    private final String callback;
    private final String target_uri;
    private final SignatureType signatureType;
    private final String scope;
    private final String responseType;
    private final OutputStream debugStream;

    public OAuthConfig(String key, String secret) {
        this(key, secret, null, null, null, null, null);
    }

    public OAuthConfig(String key, String secret, String callback, SignatureType type, String scope, String target_uri, OutputStream stream) {
        this(key, secret, callback, type, scope, "code", target_uri, stream);
    }

    public OAuthConfig(String key, String secret, String callback, SignatureType type, String scope, String responseType, String target_uri, OutputStream stream) {
        this.apiKey = key;
        this.apiSecret = secret;
        this.callback = callback;
        this.signatureType = type;
        this.scope = scope;
        this.responseType = responseType;
        this.target_uri = target_uri;
        this.debugStream = stream;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getCallback() {
        return this.callback;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getTarget_uri() {
        return this.target_uri;
    }

    public void log(String message) {
        if (this.debugStream != null) {
            message = String.valueOf(message) + "\n";
            try {
                this.debugStream.write(message.getBytes("UTF8"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return "OAuthConfig [apiKey=" + this.apiKey + ", apiSecret=" + this.apiSecret + ", callback=" + this.callback + ", target_uri=" + this.target_uri + ", signatureType=" + (Object)((Object)this.signatureType) + ", scope=" + this.scope + ", responseType=" + this.responseType + ", debugStream=" + this.debugStream + "]";
    }
}

