/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.oauth;

import com.para.secure.extractors.JacksonJsonTokenExtractor;
import com.para.secure.model.OAuth20Config;
import com.para.secure.model.OAuthRequest;
import com.para.secure.model.Response;
import com.para.secure.model.Token;
import com.para.secure.model.Verb;
import com.para.secure.oauth.IOAuth20PasswordService;

public class OAuth20PasswordServiceImpl
implements IOAuth20PasswordService {
    private static final String VERSION = "2.0";
    private static final String GRANT_TYPE = "password";
    private final OAuth20Config config;

    public OAuth20PasswordServiceImpl(OAuth20Config config) {
        this.config = config;
    }

    private String getAccessTokenEndpoint() {
        String accessTokenUrl = this.config.getAccessTokenUrl();
        StringBuilder builder = new StringBuilder(accessTokenUrl);
        if (accessTokenUrl.indexOf("?") > 0) {
            builder.append("&");
        } else {
            builder.append("?");
        }
        builder.append("grant_type=password").append("&").append("oauth_timestamp=" + System.currentTimeMillis());
        return builder.toString();
    }

    @Override
    public Response getAccessTokenResponse(String userName, String password) {
        OAuthRequest request = new OAuthRequest(Verb.GET, this.getAccessTokenEndpoint());
        request.addQuerystringParameter("client_id", this.config.getClientId());
        request.addQuerystringParameter("client_secret", this.config.getClientSerect());
        request.addQuerystringParameter("username", userName);
        request.addQuerystringParameter(GRANT_TYPE, password);
        if (this.config.hasScope()) {
            request.addQuerystringParameter("scope", this.config.getScope());
        }
        return request.send();
    }

    @Override
    public Token getAccessToken(String userName, String password) {
        Response response = this.getAccessTokenResponse(userName, password);
        return this.extractTokenResponse(response);
    }

    @Override
    public Token extractTokenResponse(Response response) {
        if (response.getBody() != null && !"".equals(response.getBody())) {
            return new JacksonJsonTokenExtractor().extract(response.getBody());
        }
        return null;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    @Override
    public void signAccessTokenRequest(Token accessToken, OAuthRequest request) {
        request.addQuerystringParameter("access_token", accessToken.getToken());
    }
}

