/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.builder;

import com.para.secure.model.OAuthConfig;
import com.para.secure.model.SignatureType;
import com.para.secure.utils.OAuthConfigUtil;
import com.para.secure.utils.Preconditions;

public class OAuthConfigBuilderFromConfig {
    private static OAuthConfigBuilderFromConfig model;
    private static OAuthConfig oAuthConfig;

    private OAuthConfigBuilderFromConfig() {
    }

    public static OAuthConfigBuilderFromConfig getInstance() {
        if (model == null) {
            model = new OAuthConfigBuilderFromConfig();
            oAuthConfig = OAuthConfigBuilderFromConfig.createOAuthConfig();
        }
        return model;
    }

    public OAuthConfig getoAuthConfig() {
        return oAuthConfig;
    }

    private static OAuthConfig createOAuthConfig() {
        String key = OAuthConfigUtil.getValue("client_id");
        String secret = OAuthConfigUtil.getValue("client_secret");
        String callback = OAuthConfigUtil.getValue("redirect_uri");
        String target_uri = OAuthConfigUtil.getValue("target_uri");
        String scopeVal = OAuthConfigUtil.getValue("scope");
        String scope = scopeVal == null || "".equals(scopeVal.trim()) ? "all" : scopeVal;
        Preconditions.checkEmptyString(key, "Invalid OAuth client_id");
        Preconditions.checkEmptyString(secret, "Invalid OAuth client_sercet");
        Preconditions.checkEmptyString(callback, "Invalid OAuth redirect_uri");
        return new OAuthConfig(key, secret, callback, SignatureType.Header, scope, target_uri, null);
    }
}

