/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.builder;

import com.para.secure.builder.OAuthApiBuilder;
import com.para.secure.builder.OAuthConfigBuilder;
import com.para.secure.builder.api.Api;
import com.para.secure.builder.api.DefaultApi10a;
import com.para.secure.builder.api.DefaultApi20;
import com.para.secure.builder.api.OAuthApi20;
import com.para.secure.exceptions.OAuthException;
import com.para.secure.model.OAuth20Config;
import com.para.secure.model.OAuthConfig;
import com.para.secure.oauth.IOAuth10Service;
import com.para.secure.oauth.IOAuth20Service;
import com.para.secure.utils.Preconditions;

public class OAuthServiceBuilder {
    private OAuthConfig config;
    private Api api;

    public OAuthServiceBuilder(OAuth20Config info) {
        OAuthConfig config = new OAuthConfigBuilder().apiKey(info.getClientId()).apiSecret(info.getClientSerect()).callback(info.getRedirectUri()).target_uri(info.getTarget_uri()).buildConfig();
        OAuthApi20 api = new OAuthApiBuilder().authorizeUrl(info.getAuthorizeUrl()).accessTokenUrl(info.getAccessTokenUrl()).buildApi20();
        this.providerConfig(config);
        this.providerApi(api);
    }

    private OAuthServiceBuilder providerConfig(OAuthConfig config) {
        Preconditions.checkNotNull(config, "OAuthConfig cannot be null");
        this.config = config;
        return this;
    }

    private OAuthServiceBuilder providerApi(Class<? extends Api> apiClass) {
        this.api = this.createApi(apiClass);
        return this;
    }

    private Api createApi(Class<? extends Api> apiClass) {
        Api api;
        Preconditions.checkNotNull(apiClass, "Api class cannot be null");
        try {
            api = apiClass.newInstance();
        }
        catch (Exception e) {
            throw new OAuthException("Error while creating the Api object", e);
        }
        return api;
    }

    private OAuthServiceBuilder providerApi(Api api) {
        Preconditions.checkNotNull(api, "Api cannot be null");
        this.api = api;
        return this;
    }

    public IOAuth20Service build20Service() {
        Preconditions.checkNotNull(this.config, "OAuthConfig cannot be null");
        Preconditions.checkNotNull(this.api, "Api cannot be null");
        if (!(this.api instanceof DefaultApi20)) {
            throw new OAuthException("Api Type Is Validate");
        }
        return (IOAuth20Service)this.api.createService(this.config);
    }

    public IOAuth10Service build10Service() {
        Preconditions.checkNotNull(this.config, "OAuthConfig cannot be null");
        Preconditions.checkNotNull(this.api, "Api cannot be null");
        if (!(this.api instanceof DefaultApi10a)) {
            throw new OAuthException("Api Type Is Validate");
        }
        return (IOAuth10Service)this.api.createService(this.config);
    }
}

