/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.builder.api;

import com.para.secure.builder.api.DefaultApi20;
import com.para.secure.extractors.AccessTokenExtractor;
import com.para.secure.extractors.JacksonJsonTokenExtractor;
import com.para.secure.model.OAuthConfig;
import com.para.secure.utils.OAuthEncoder;
import com.para.secure.utils.Preconditions;

public class OAuthApi20
extends DefaultApi20 {
    private static final String AUTHORIZATION_URL = "client_id=%s&response_type=%s&redirect_uri=%s&target_uri=%s&oauth_timestamp=%s";
    private static final String SCOPED_AUTHORIZE_URL = "&scope=%s";
    private String authorizeUrl;
    private String accessTokenUrl;
    private String grantType = "authorization_code";
    private String responseType = "code";

    public OAuthApi20(String authorizeUrl, String accessTokenUrl) {
        this.authorizeUrl = authorizeUrl;
        this.accessTokenUrl = accessTokenUrl;
    }

    @Override
    public String getAccessTokenEndpoint() {
        if (this.accessTokenUrl.indexOf("?") > 0) {
            return String.valueOf(this.accessTokenUrl) + "&grant_type=" + this.grantType + "&oauth_timestamp=" + System.currentTimeMillis();
        }
        return String.valueOf(this.accessTokenUrl) + "?grant_type=" + this.grantType + "&oauth_timestamp=" + System.currentTimeMillis();
    }

    @Override
    public String getAuthorizationUrl(OAuthConfig config) {
        Preconditions.checkValidUrl(config.getCallback(), "Must provide a valid url as callback. ParaSecure does not support OOB");
        if (config.hasScope()) {
            return String.format(String.valueOf(this.getAuthorizeUrl()) + SCOPED_AUTHORIZE_URL, config.getApiKey(), config.getResponseType(), OAuthEncoder.encode(config.getCallback()), config.getTarget_uri(), System.currentTimeMillis(), OAuthEncoder.encode(config.getScope()));
        }
        return String.format(this.getAuthorizeUrl(), config.getApiKey(), config.getResponseType(), OAuthEncoder.encode(config.getCallback()), config.getTarget_uri(), System.currentTimeMillis());
    }

    private String getAuthorizeUrl() {
        if (this.authorizeUrl.indexOf("?") > 0) {
            return String.valueOf(this.authorizeUrl) + "&" + AUTHORIZATION_URL;
        }
        return String.valueOf(this.authorizeUrl) + "?" + AUTHORIZATION_URL;
    }

    @Override
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new JacksonJsonTokenExtractor();
    }

    public void setAuthorizeUrl(String authorizeUrl) {
        this.authorizeUrl = authorizeUrl;
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    @Override
    public String getRefreshTokenEndpoint() {
        if (this.accessTokenUrl.indexOf("?") > 0) {
            return String.valueOf(this.accessTokenUrl) + "&grant_type=refresh_token";
        }
        return String.valueOf(this.accessTokenUrl) + "?grant_type=refresh_token";
    }
}

