/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.builder.api;

import com.para.secure.builder.api.DefaultApi20;
import com.para.secure.extractors.AccessTokenExtractor;
import com.para.secure.extractors.JacksonJsonTokenExtractor;
import com.para.secure.model.OAuth20Config;
import com.para.secure.model.OAuthConfig;
import com.para.secure.model.Verb;

public class OAuthPasswordApi20
extends DefaultApi20 {
    private String accessTokenUrl;
    private String grantType = "password";
    private String scope = "&scope=%s";
    private String accessTokenMethod = "POST";
    private static final String AUTHORIZE_PARAM = "&client_id=%s&client_secret=%s&username=%s&password=%s";

    public OAuthPasswordApi20(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    @Override
    public Verb getAccessTokenVerb() {
        if (this.accessTokenMethod != null && this.accessTokenMethod.toUpperCase().equals("POST")) {
            return Verb.POST;
        }
        return Verb.GET;
    }

    @Override
    public AccessTokenExtractor getAccessTokenExtractor() {
        return new JacksonJsonTokenExtractor();
    }

    @Override
    public String getAccessTokenEndpoint() {
        if (this.accessTokenUrl.indexOf("?") > 0) {
            return String.valueOf(this.accessTokenUrl) + "&grant_type=" + this.grantType + AUTHORIZE_PARAM;
        }
        return String.valueOf(this.accessTokenUrl) + "?grant_type=" + this.grantType + AUTHORIZE_PARAM;
    }

    public String getAuthorizationUrl(OAuth20Config config, String username, String password) {
        return String.format(this.getAccessTokenEndpoint(), config.getClientId(), config.getClientSerect(), username, password);
    }

    public String getAccessTokenUrl() {
        return this.accessTokenUrl;
    }

    public void setAccessTokenUrl(String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
    }

    public String toString() {
        return "OAuthApi20 [accessTokenUrl=" + this.accessTokenUrl + ", grantType=" + this.grantType + ", scope=" + this.scope + "]";
    }

    @Override
    public String getAuthorizationUrl(OAuthConfig config) {
        return "";
    }

    @Override
    public String getRefreshTokenEndpoint() {
        return null;
    }
}

