/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.extractors;

import com.para.secure.exceptions.OAuthException;
import com.para.secure.extractors.AccessTokenExtractor;
import com.para.secure.model.Token;
import com.para.secure.utils.Json2ObjectUtil;
import com.para.secure.utils.Preconditions;
import java.util.HashMap;

public class JacksonJsonTokenExtractor
implements AccessTokenExtractor {
    @Override
    public Token extract(String response) {
        Preconditions.checkEmptyString(response, "Cannot extract a token from a null or empty String");
        try {
            HashMap tokenMap = new HashMap();
            tokenMap = (HashMap)Json2ObjectUtil.json2Object(response, tokenMap);
            String accessToken = this.obj2Str(tokenMap.get("access_token"));
            String tokenType = this.obj2Str(tokenMap.get("token_type"));
            String refreshToken = this.obj2Str(tokenMap.get("refresh_token"));
            String expiresIn = this.obj2Str(tokenMap.get("expires_in"));
            Token token = new Token(accessToken, tokenType, response);
            token.setRefreshToken(refreshToken);
            token.setExpires_in(expiresIn);
            return token;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OAuthException("Cannot extract an acces token. Response was: " + response);
        }
    }

    @Override
    public Token extractESCToken(String response) {
        Preconditions.checkEmptyString(response, "Cannot extract a token from a null or empty String");
        try {
            HashMap<String, String> tokenMap = new HashMap<String, String>();
            String[] strs = response.split("&");
            if (strs.length > 0) {
                int strsCount = 0;
                while (strsCount < strs.length) {
                    String str = strs[strsCount];
                    String[] keyValue = str.split("=");
                    if (keyValue.length == 2) {
                        tokenMap.put(keyValue[0], keyValue[1]);
                    }
                    ++strsCount;
                }
            }
            String accessToken = this.obj2Str(tokenMap.get("access_token"));
            String tokenType = this.obj2Str(tokenMap.get("token_type"));
            String refreshToken = this.obj2Str(tokenMap.get("refresh_token"));
            String expiresIn = this.obj2Str(tokenMap.get("expires_in"));
            Token token = new Token(accessToken, tokenType, response);
            token.setRefreshToken(refreshToken);
            token.setExpires_in(expiresIn);
            return token;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OAuthException("Cannot extract an acces token. Response was: " + response);
        }
    }

    private String obj2Str(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }
}

