/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.oauth;

import com.para.secure.builder.OAuthServiceBuilder;
import com.para.secure.model.OAuth20Config;
import com.para.secure.model.Token;
import com.para.secure.oauth.IOAuth20Service;
import com.para.secure.utils.OAuthConfigUtil;

public class OAuthService {
    IOAuth20Service oAuth20Service;

    public OAuthService() {
        String clientId = OAuthConfigUtil.getClientId();
        String clientSerect = OAuthConfigUtil.getClientSecret();
        String redirectUri = OAuthConfigUtil.getRedirectUri();
        String authorizeUrl = OAuthConfigUtil.getAuthorizeUrl();
        String accessTokenUrl = OAuthConfigUtil.getAccessTokenUrl();
        OAuth20Config oAuth20Config = new OAuth20Config(clientId, clientSerect, redirectUri, authorizeUrl, accessTokenUrl);
        this.oAuth20Service = new OAuthServiceBuilder(oAuth20Config).build20Service();
    }

    public OAuthService(String clientId, String clientSerect, String redirectUri) {
        String authorizeUrl = OAuthConfigUtil.getAuthorizeUrl();
        String accessTokenUrl = OAuthConfigUtil.getAccessTokenUrl();
        OAuth20Config oAuth20Config = new OAuth20Config(clientId, clientSerect, redirectUri, authorizeUrl, accessTokenUrl);
        this.oAuth20Service = new OAuthServiceBuilder(oAuth20Config).build20Service();
    }

    public OAuthService(String clientId, String clientSerect, String redirectUri, String target_uri) {
        String authorizeUrl = OAuthConfigUtil.getAuthorizeUrl();
        String accessTokenUrl = OAuthConfigUtil.getAccessTokenUrl();
        OAuth20Config oAuth20Config = new OAuth20Config(clientId, clientSerect, redirectUri, authorizeUrl, accessTokenUrl, target_uri);
        this.oAuth20Service = new OAuthServiceBuilder(oAuth20Config).build20Service();
    }

    public String getAuthorizationUrl() {
        return this.oAuth20Service.getAuthorizationUrl();
    }

    public Token getAccessToken(String code) {
        Token accessToken = this.oAuth20Service.getAccessToken(code);
        return accessToken;
    }
}

