/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.services;

import com.para.secure.exceptions.OAuthSignatureException;
import com.para.secure.services.SignatureService;
import com.para.secure.utils.OAuthEncoder;
import com.para.secure.utils.Preconditions;

public class PlaintextSignatureService
implements SignatureService {
    private static final String METHOD = "plaintext";

    @Override
    public String getSignature(String baseString, String apiSecret, String tokenSecret) {
        try {
            Preconditions.checkEmptyString(apiSecret, "Api secret cant be null or empty string");
            return String.valueOf(OAuthEncoder.encode(apiSecret)) + '&' + OAuthEncoder.encode(tokenSecret);
        }
        catch (Exception e) {
            throw new OAuthSignatureException(baseString, e);
        }
    }

    @Override
    public String getSignatureMethod() {
        return METHOD;
    }
}

