/*
 * Decompiled with CFR 0.152.
 */
package com.para.secure.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class OAuthConfigUtil {
    public static final String DEFAULT_GRANT_TYPE = "authorization_code";
    public static final String GRANT_TYPE_KEY = "app.config.oauth.parasecure.granttype";
    private static Properties OAuthConfigProperties = new Properties();

    static {
        try {
            OAuthConfigProperties.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("oauthconfig.properties"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getGrantType() {
        String grantType = OAuthConfigProperties.getProperty(GRANT_TYPE_KEY);
        if (grantType == null || "".equals(grantType)) {
            grantType = DEFAULT_GRANT_TYPE;
        }
        return grantType;
    }

    public static String getAuthorizeUrl() {
        return OAuthConfigUtil.getValue("config.authorize.url");
    }

    public static String getAccessTokenUrl() {
        return OAuthConfigUtil.getValue("config.accesstoken.url");
    }

    public static String getUserInfoUrl() {
        return OAuthConfigUtil.getValue("config.api.users.userinfo");
    }

    public static String getClientId() {
        return OAuthConfigUtil.getValue("config.authorization_code.client_id");
    }

    public static String getClientSecret() {
        return OAuthConfigUtil.getValue("config.authorization_code.client_secret");
    }

    public static String getRedirectUri() {
        return OAuthConfigUtil.getValue("config.authorization_code.redirect_uri");
    }

    public static String getValue(String key) {
        return OAuthConfigProperties.getProperty(key);
    }

    public static void main(String[] args) {
    }

    public static final class CONFIG {
        public static final String BASE_URL = "config.base.url";
        public static final String AUTHORIZE_URL = "config.authorize.url";
        public static final String ACCESSTOKEN_URL = "config.accesstoken.url";
        public static final String API_USRES_USERINFO = "config.api.users.userinfo";
        public static final String AUTHORIZATION_CODE_CLIENTID = "config.authorization_code.client_id";
        public static final String AUTHORIZATION_CODE_CLIENTSECRET = "config.authorization_code.client_secret";
        public static final String AUTHORIZATION_CODE_REDIRECTURI = "config.authorization_code.redirect_uri";
        public static final String AUTHORIZATION_CODE_RESPONSE_TYPE = "config.authorization_code.responsetype";
        public static final String AUTHORIZATION_CODE_APPROVAL_PROMPT = "config.authorization_code.approvalprompt";
        public static final String AUTHORIZATION_CODE_GRANT_TYPE = "config.authorization_code.granttype";
        public static final String PASSWORD_CLIENTID = "config.password.client_id";
        public static final String PASSWORD_CLIENTSECRET = "config.password.client_secret";
        public static final String PASSWORD_REDIRECTURI = "config.password.redirect_uri";
        public static final String PASSWORD_RESPONSE_TYPE = "config.password.responsetype";
        public static final String PASSWORD_APPROVAL_PROMPT = "config.password.approvalprompt";
        public static final String PASSWORD_GRANT_TYPE = "config.password.granttype";
    }
}

