/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClusterClient;
import com.alibaba.nacos.common.remote.client.grpc.GrpcSdkClient;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcClientFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"com.alibaba.nacos.common.remote.client");
    private static final Map<String, RpcClient> CLIENT_MAP = new ConcurrentHashMap<String, RpcClient>();

    public static Set<Map.Entry<String, RpcClient>> getAllClientEntries() {
        return CLIENT_MAP.entrySet();
    }

    public static void destroyClient(String clientName) throws NacosException {
        RpcClient rpcClient = CLIENT_MAP.remove(clientName);
        if (rpcClient != null) {
            rpcClient.shutdown();
        }
    }

    public static RpcClient getClient(String clientName) {
        return CLIENT_MAP.get(clientName);
    }

    public static RpcClient createClient(String clientName, ConnectionType connectionType, Map<String, String> labels) {
        return CLIENT_MAP.compute(clientName, (clientNameInner, client) -> {
            if (client == null) {
                LOGGER.info("[RpcClientFactory] create a new rpc client of " + clientName);
                if (ConnectionType.GRPC.equals((Object)connectionType)) {
                    client = new GrpcSdkClient((String)clientNameInner);
                }
                if (client == null) {
                    throw new UnsupportedOperationException("unsupported connection type :" + connectionType.getType());
                }
                client.labels(labels);
            }
            return client;
        });
    }

    public static RpcClient createClusterClient(String clientName, ConnectionType connectionType, Map<String, String> labels) {
        return CLIENT_MAP.compute(clientName, (clientNameInner, client) -> {
            if (client == null) {
                if (ConnectionType.GRPC.equals((Object)connectionType)) {
                    client = new GrpcClusterClient((String)clientNameInner);
                }
                if (client == null) {
                    throw new UnsupportedOperationException("unsupported connection type :" + connectionType.getType());
                }
                client.labels(labels);
                return client;
            }
            return client;
        });
    }
}

