/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.consistency;

import com.alibaba.nacos.consistency.entity.GetRequest;
import com.alibaba.nacos.consistency.entity.Log;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.consistency.exception.ConsistencyException;
import com.google.protobuf.Message;

public class ProtoMessageUtil {
    public static Message parse(byte[] bytes) {
        try {
            WriteRequest result = WriteRequest.parseFrom(bytes);
            return result;
        }
        catch (Throwable throwable) {
            try {
                ReadRequest result = ReadRequest.parseFrom(bytes);
                return result;
            }
            catch (Throwable throwable2) {
                try {
                    Log log = Log.parseFrom(bytes);
                    return ProtoMessageUtil.convertToWriteRequest(log);
                }
                catch (Throwable log) {
                    try {
                        GetRequest request = GetRequest.parseFrom(bytes);
                        return ProtoMessageUtil.convertToReadRequest(request);
                    }
                    catch (Throwable throwable3) {
                        throw new ConsistencyException("The current array cannot be serialized to the corresponding object");
                    }
                }
            }
        }
    }

    public static WriteRequest convertToWriteRequest(Log log) {
        return WriteRequest.newBuilder().setKey(log.getKey()).setGroup(log.getGroup()).setData(log.getData()).setType(log.getType()).setOperation(log.getOperation()).putAllExtendInfo(log.getExtendInfoMap()).build();
    }

    public static ReadRequest convertToReadRequest(GetRequest request) {
        return ReadRequest.newBuilder().setGroup(request.getGroup()).setData(request.getData()).putAllExtendInfo(request.getExtendInfoMap()).build();
    }
}

