/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.mcp;

import com.alibaba.nacos.istio.mcp.McpServerIntercepter;
import com.alibaba.nacos.istio.mcp.NacosMcpOverXdsService;
import com.alibaba.nacos.istio.mcp.NacosMcpService;
import com.alibaba.nacos.istio.mcp.NacosToMcpResources;
import com.alibaba.nacos.istio.misc.IstioConfig;
import com.alibaba.nacos.istio.misc.Loggers;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NacosMcpServer {
    private final int port = 18848;
    private Server server;
    @Autowired
    private IstioConfig istioConfig;
    @Autowired
    private McpServerIntercepter intercepter;
    @Autowired
    private NacosMcpService nacosMcpService;
    @Autowired
    private NacosMcpOverXdsService nacosMcpOverXdsService;
    @Autowired
    private NacosToMcpResources nacosToMcpResources;

    @PostConstruct
    public void start() throws IOException {
        if (!this.istioConfig.isMcpServerEnabled()) {
            return;
        }
        Loggers.MAIN.info("MCP server, starting Nacos MCP server...");
        this.server = ServerBuilder.forPort((int)18848).addService(ServerInterceptors.intercept((BindableService)this.nacosMcpService, (ServerInterceptor[])new ServerInterceptor[]{this.intercepter})).addService(ServerInterceptors.intercept((BindableService)this.nacosMcpOverXdsService, (ServerInterceptor[])new ServerInterceptor[]{this.intercepter})).build();
        this.server.start();
        this.nacosToMcpResources.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("Stopping Nacos MCP server...");
                NacosMcpServer.this.stop();
                System.out.println("Nacos MCP server stopped...");
            }
        });
    }

    public void stop() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }
}

