/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.core.kafka;

import com.plumelog.core.client.AbstractClient;
import com.plumelog.core.exception.LogQueueConnectException;
import com.plumelog.core.kafka.KafkaProducerPool;
import java.util.List;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaProducerClient
extends AbstractClient {
    private static KafkaProducerClient instance;
    private KafkaProducerPool kafkaProducerPool;

    private KafkaProducerClient(String hosts, String compressionType) {
        this.kafkaProducerPool = new KafkaProducerPool(hosts, compressionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KafkaProducerClient getInstance(String hosts, String compressionType) {
        if (instance != null) return instance;
        Class<KafkaProducerClient> clazz = KafkaProducerClient.class;
        synchronized (KafkaProducerClient.class) {
            if (instance != null) return instance;
            instance = new KafkaProducerClient(hosts, compressionType);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void pushMessage(String topic, String message) throws LogQueueConnectException {
        KafkaProducer kafkaProducer = null;
        try {
            kafkaProducer = this.kafkaProducerPool.getResource();
            kafkaProducer.send(new ProducerRecord(topic, (Object)message));
        }
        catch (Exception e) {
            throw new LogQueueConnectException("kafka \u5199\u5165\u5931\u8d25\uff01", e);
        }
        finally {
            if (kafkaProducer != null) {
                this.kafkaProducerPool.returnResource(kafkaProducer);
            }
        }
    }

    @Override
    public void putMessageList(String topic, List<String> list) throws LogQueueConnectException {
        KafkaProducer kafkaProducer = null;
        try {
            kafkaProducer = this.kafkaProducerPool.getResource();
            for (int a = 0; a < list.size(); ++a) {
                String message = list.get(a);
                kafkaProducer.send(new ProducerRecord(topic, (Object)message));
            }
        }
        catch (Exception e) {
            throw new LogQueueConnectException("kafka \u5199\u5165\u5931\u8d25\uff01", e);
        }
        finally {
            if (kafkaProducer != null) {
                this.kafkaProducerPool.returnResource(kafkaProducer);
            }
        }
    }
}

