/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.core.redis;

import com.plumelog.core.client.AbstractClient;
import com.plumelog.core.exception.LogQueueConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;

public class RedisSentinelClient
extends AbstractClient {
    private static final String script = "local rs=redis.call('setnx',KEYS[1],ARGV[1]);if(rs<1) then return 0;end;redis.call('expire',KEYS[1],tonumber(ARGV[2]));return 1;";
    private static RedisSentinelClient instance;
    private JedisSentinelPool jedisSentinelPool = null;
    private final int MAX_ACTIVE = 30;
    private final int MAX_IDLE = 8;
    private final int MAX_WAIT = 1000;
    private final boolean TEST_ON_BORROW = true;

    public RedisSentinelClient(String hosts, String masterName, String pass, int db) {
        String[] clusterHosts = hosts.split(",");
        HashSet<String> sentinels = new HashSet<String>();
        for (int a = 0; a < clusterHosts.length; ++a) {
            sentinels.add(clusterHosts[a]);
        }
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxTotal(30);
        config.setMaxIdle(8);
        config.setMaxWaitMillis(1000L);
        config.setTestOnBorrow(true);
        this.jedisSentinelPool = pass != null && !"".equals(pass) ? new JedisSentinelPool(masterName, sentinels, (GenericObjectPoolConfig)config, 2000, pass, db) : new JedisSentinelPool(masterName, sentinels, (GenericObjectPoolConfig)config, 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisSentinelClient getInstance(String hosts, String masterName, String pass, int db) {
        if (instance != null) return instance;
        Class<RedisSentinelClient> clazz = RedisSentinelClient.class;
        synchronized (RedisSentinelClient.class) {
            if (instance != null) return instance;
            instance = new RedisSentinelClient(hosts, masterName, pass, db);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void pushMessage(String key, String strings) throws LogQueueConnectException {
        try (Jedis sj = null;){
            sj = this.jedisSentinelPool.getResource();
            sj.rpush(key, new String[]{strings});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setNx(String key, Integer expire) {
        if (null == key) {
            return false;
        }
        try (Jedis jedis = this.jedisSentinelPool.getResource();){
            Long result = (Long)jedis.evalsha(jedis.scriptLoad(script), Arrays.asList(key), Arrays.asList(key, String.valueOf(expire)));
            jedis.close();
            if (result == 1L) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsKey(String key) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            boolean bl = sj.exists(key);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMessage(String key) {
        String obj;
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            obj = sj.lpop(key);
        }
        return obj;
    }

    @Override
    public void putMessageList(String key, List<String> list) throws LogQueueConnectException {
        try (Jedis sj = null;){
            sj = this.jedisSentinelPool.getResource();
            Pipeline pl = sj.pipelined();
            list.forEach(str -> pl.rpush(key, new String[]{str}));
            pl.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            sj.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value, int seconds) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            Pipeline pl = sj.pipelined();
            pl.set(key, value);
            pl.expire(key, seconds);
            pl.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireAt(String key, Long time) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            sj.expireAt(key, time.longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire(String key, int seconds) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            sj.expire(key, seconds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incr(String key) {
        Long re = 0L;
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            re = sj.incr(key);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long incrBy(String key, int value) {
        Long re = 0L;
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            re = sj.incrBy(key, (long)value);
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hset(String key, Map<String, String> value) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            sj.hset(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sadd(String key, String value) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            sj.sadd(key, new String[]{value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> smembers(String key) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            Set set = sj.smembers(key);
            return set;
        }
    }

    @Override
    public void del(String key) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            sj.del(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hset(String key, String field, String value) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            sj.hset(key, field, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hdel(String key, String ... field) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            sj.hdel(key, field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String hget(String key, String field) {
        String value = "";
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            value = sj.hget(key, field);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long llen(String key) {
        Long value = 0L;
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            value = sj.llen(key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> hgetAll(String key) {
        HashMap<String, String> value = new HashMap();
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            value = sj.hgetAll(key);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> hmget(String key, String ... field) {
        ArrayList<String> value = new ArrayList();
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            value = sj.hmget(key, field);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hincrby(String key, String field, int num) {
        Long re = 0L;
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            re = sj.hincrBy(key, field, (long)num);
        }
        return re;
    }

    @Override
    public List<String> getMessage(String key, int size) throws LogQueueConnectException {
        ArrayList<String> list = new ArrayList<String>();
        try (Jedis sj = null;){
            Response res2;
            sj = this.jedisSentinelPool.getResource();
            Long count = sj.llen(key);
            if (count < (long)size) {
                size = count.intValue();
            }
            if (size == 0) {
                ArrayList<String> arrayList = list;
                return arrayList;
            }
            ArrayList<Response> listRes = new ArrayList<Response>();
            Pipeline pl = sj.pipelined();
            for (int i = 0; i < size && (res2 = pl.lpop(key)) != null; ++i) {
                listRes.add(res2);
            }
            pl.sync();
            listRes.forEach(res -> {
                String log = (String)res.get();
                if (log != null) {
                    list.add(log);
                }
            });
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String channel, String message) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            sj.publish(channel, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(JedisPubSub jedisPubSub, String ... channel) {
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            sj.subscribe(jedisPubSub, channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long hlen(String key) {
        Long re = 0L;
        try (Jedis sj = this.jedisSentinelPool.getResource();){
            re = sj.hlen(key);
        }
        return re;
    }
}

