/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.triplestore.api;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCatalog
extends HashMap<String, String> {
    private final String resource;
    private static final String QUERY_DEFINITION = "query:";
    private static final String INCLUDE = "include:";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Logger LOG = LoggerFactory.getLogger(QueryCatalog.class);

    private InputStream resourceStream(String resource) {
        return this.getClass().getClassLoader().getResourceAsStream(resource);
    }

    public QueryCatalog(String resource) {
        this.resource = resource;
        this.load(this.resourceStream(resource), new ParsingContext());
    }

    public String resource() {
        return this.resource;
    }

    private void load(InputStream ir, ParsingContext context) {
        try (Stream<String> stream = new BufferedReader(new InputStreamReader(ir)).lines();){
            stream.forEach((? super T line) -> this.parse((String)line, context));
        }
        context.leaveQuery();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resource);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QueryCatalog)) {
            return false;
        }
        QueryCatalog q = (QueryCatalog)obj;
        return this.resource.equals(q.resource);
    }

    private void parse(String line, ParsingContext context) {
        if (QueryCatalog.queryDefinition(line)) {
            context.enterQuery(line);
        } else if (QueryCatalog.include(line)) {
            context.leaveQuery();
            this.load(this.resourceStream(QueryCatalog.includedResource(line)), context);
        } else if (!QueryCatalog.comment(line)) {
            context.appendText(line);
        }
    }

    private static boolean queryDefinition(String line) {
        if (!QueryCatalog.comment(line)) {
            return false;
        }
        return line.contains(QUERY_DEFINITION);
    }

    private static boolean comment(String line) {
        return line.trim().startsWith("#");
    }

    private static boolean include(String line) {
        return line.contains(INCLUDE);
    }

    private static String includedResource(String line) {
        int p = line.indexOf(INCLUDE);
        assert (p > 0);
        return line.substring(p + INCLUDE.length()).trim();
    }

    class ParsingContext {
        private final StringBuilder queryText = new StringBuilder(2048);
        private String queryName = null;

        ParsingContext() {
        }

        void enterQuery(String line) {
            this.leaveQuery();
            int p = line.indexOf(QueryCatalog.QUERY_DEFINITION);
            assert (p > 0);
            this.queryName = line.substring(p + QueryCatalog.QUERY_DEFINITION.length()).trim();
        }

        void leaveQuery() {
            if (this.queryName != null) {
                LOG.debug("loaded query [{}]", (Object)this.queryName);
                QueryCatalog.this.put(this.queryName, this.queryText.toString());
                this.queryName = null;
                this.queryText.setLength(0);
            }
        }

        void appendText(String line) {
            this.queryText.append(line);
            this.queryText.append(LINE_SEPARATOR);
        }
    }
}

