/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.job.v2.DocAIGCMetadata;
import com.qcloud.cos.model.ciModel.job.v2.DocAIGCMetadataConfig;
import com.qcloud.cos.model.ciModel.job.v2.DocAIGCMetadataInput;
import com.qcloud.cos.model.ciModel.job.v2.DocAIGCMetadataJobRequest;
import com.qcloud.cos.model.ciModel.job.v2.DocAIGCMetadataJobResponse;
import com.qcloud.cos.model.ciModel.job.v2.DocAIGCMetadataOperation;
import com.qcloud.cos.model.ciModel.job.v2.DocAIGCMetadataOutput;
import com.qcloud.cos.utils.Jackson;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class DocAIGCMetadataJobDemo {
    public static void main(String[] args) throws Exception {
        COSClient client = ClientUtils.getTestClient();
        DocAIGCMetadataJobDemo.createDocAIGCMetadataJob(client);
    }

    public static void createDocAIGCMetadataJob(COSClient client) {
        DocAIGCMetadataJobRequest request = new DocAIGCMetadataJobRequest();
        request.setBucketName("demo-1251704708");
        DocAIGCMetadataInput input = request.getInput();
        input.setObject("test.pdf");
        DocAIGCMetadataOperation operation = request.getOperation();
        DocAIGCMetadataConfig docAIGCConfig = operation.getDocAIGCMetadata();
        DocAIGCMetadata aigcMetadata = docAIGCConfig.getAigcMetadata();
        aigcMetadata.setLabel("1");
        aigcMetadata.setContentProducer("testProducer");
        aigcMetadata.setProduceId("${JobId}_${InputName}");
        String reservedCode1 = Base64.getUrlEncoder().withoutPadding().encodeToString("security_info_1".getBytes(StandardCharsets.UTF_8));
        aigcMetadata.setReservedCode1(reservedCode1);
        aigcMetadata.setContentPropagator("testPropagator");
        aigcMetadata.setPropagateId("${JobId}_propagate");
        String reservedCode2 = Base64.getUrlEncoder().withoutPadding().encodeToString("security_info_2".getBytes(StandardCharsets.UTF_8));
        aigcMetadata.setReservedCode2(reservedCode2);
        DocAIGCMetadataOutput output = operation.getOutput();
        output.setRegion("ap-chongqing");
        output.setBucket("demo-1251704708");
        output.setObject("/abc_${Number}.pdf");
        DocAIGCMetadataJobResponse response = client.createDocAIGCMetadataJob(request);
        System.out.println(Jackson.toJsonString(response));
    }
}

