/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.BaseUploader;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Recorder;
import com.qiniu.storage.Region;
import com.qiniu.storage.RegionGroup;
import com.qiniu.storage.ResumeUploadPerformer;
import com.qiniu.storage.ResumeUploadPerformerV1;
import com.qiniu.storage.ResumeUploadPerformerV2;
import com.qiniu.storage.ResumeUploadSource;
import com.qiniu.storage.ResumeUploadSourceFile;
import com.qiniu.storage.ResumeUploadSourceStream;
import com.qiniu.storage.UploadOptions;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;
import java.io.File;
import java.io.InputStream;

public class ResumeUploader
extends BaseUploader {
    private final ResumeUploadSource source;
    private final Recorder recorder;
    private final UploadOptions options;
    ResumeUploadPerformer uploadPerformer;

    public ResumeUploader(Client client, String upToken, String key, File file, StringMap params, String mime, Recorder recorder, Configuration configuration) {
        this(client, key, upToken, new ResumeUploadSourceFile(file, configuration, ResumeUploader.getRecorderKey(key, file, recorder)), recorder, new UploadOptions.Builder().params(params).metaData(params).mimeType(mime).build(), configuration);
    }

    public ResumeUploader(Client client, String upToken, String key, InputStream stream, StringMap params, String mime, Configuration configuration) {
        this(client, upToken, key, stream, null, params, mime, configuration);
    }

    public ResumeUploader(Client client, String upToken, String key, InputStream stream, String fileName, StringMap params, String mime, Configuration configuration) {
        this(client, key, upToken, new ResumeUploadSourceStream(stream, configuration, null, fileName), null, new UploadOptions.Builder().params(params).metaData(params).mimeType(mime).build(), configuration);
    }

    private ResumeUploader(Client client, String key, String upToken, ResumeUploadSource source, Recorder recorder, UploadOptions options, Configuration configuration) {
        super(client, upToken, key, configuration);
        this.source = source;
        this.recorder = recorder;
        this.options = options == null ? UploadOptions.defaultOptions() : options;
    }

    @Override
    public Response upload() throws QiniuException {
        try {
            this.recoverUploadProgressFromLocal();
            Response response = super.upload();
            if (response != null && (response.isOK() || response.isContextExpiredError())) {
                this.removeUploadProgressFromLocal();
            }
            Response response2 = response;
            return response2;
        }
        catch (QiniuException e) {
            this.saveUploadProgressToLocal();
            throw e;
        }
        finally {
            this.close();
        }
    }

    @Override
    Response uploadFlows() throws QiniuException {
        this.checkParam();
        UploadToken token = new UploadToken(this.upToken);
        this.uploadPerformer = this.config.resumableUploadAPIVersion == Configuration.ResumableUploadAPIVersion.V2 ? new ResumeUploadPerformerV2(this.client, this.key, token, this.source, this.recorder, this.options, this.config) : new ResumeUploadPerformerV1(this.client, this.key, token, this.source, this.recorder, this.options, this.config);
        Response response = null;
        if (this.uploadPerformer.shouldUploadInit() && !(response = this.uploadPerformer.uploadInit()).isOK()) {
            return response;
        }
        if (!this.uploadPerformer.isAllBlocksUploaded() && !(response = this.uploadData()).isOK()) {
            return response;
        }
        response = this.uploadPerformer.completeUpload();
        return response;
    }

    Response uploadData() throws QiniuException {
        Response response = null;
        do {
            response = this.uploadPerformer.uploadNextData();
        } while (!this.uploadPerformer.isAllBlocksUploadingOrUploaded());
        return response;
    }

    @Override
    boolean couldReloadSource() {
        return this.source.couldReload();
    }

    @Override
    boolean reloadSource() {
        if (this.source.reload()) {
            this.source.clearState();
            return true;
        }
        return false;
    }

    private void close() {
        try {
            this.source.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkParam() throws QiniuException {
        if (this.client == null) {
            throw QiniuException.unrecoverable(new Exception("client can't be empty"));
        }
        if (this.config == null) {
            throw QiniuException.unrecoverable(new Exception("Configuration can't be empty"));
        }
        if (this.config.zone == null && this.config.region == null) {
            throw QiniuException.unrecoverable(new Exception("Configuration.region can't be empty"));
        }
        if (!this.source.isValid()) {
            throw QiniuException.unrecoverable(new Exception("InputStream or File is invalid"));
        }
        UploadToken token = new UploadToken(this.upToken);
        if (!token.isValid()) {
            throw QiniuException.unrecoverable(new Exception("token is invalid"));
        }
    }

    private static String getRecorderKey(String key, File file, Recorder recorder) {
        if (recorder == null) {
            return null;
        }
        return recorder.recorderKeyGenerate(key, file);
    }

    void recoverUploadProgressFromLocal() {
        if (this.recorder == null || this.source == null || StringUtils.isNullOrEmpty(this.source.recordKey)) {
            return;
        }
        byte[] data = this.recorder.get(this.source.recordKey);
        if (data == null) {
            return;
        }
        String jsonString = new String(data, Constants.UTF_8);
        Region region = null;
        ResumeUploadSource uploadSource = null;
        try {
            JsonObject jsonObject = (JsonObject)new JsonParser().parse(jsonString);
            JsonObject sourceJson = jsonObject.getAsJsonObject("source");
            uploadSource = (ResumeUploadSource)new Gson().fromJson((JsonElement)sourceJson, this.source.getClass());
            JsonObject regionJson = jsonObject.getAsJsonObject("region");
            region = (Region)new Gson().fromJson((JsonElement)regionJson, Region.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (uploadSource == null || region == null) {
            this.removeUploadProgressFromLocal();
            return;
        }
        if (!this.source.recoverFromRecordInfo(uploadSource)) {
            this.removeUploadProgressFromLocal();
            return;
        }
        if (this.config.region == null) {
            this.config.region = region;
        } else {
            RegionGroup regionGroup = new RegionGroup();
            regionGroup.addRegion(region);
            regionGroup.addRegion(this.config.region);
            this.config.region = regionGroup;
        }
    }

    void saveUploadProgressToLocal() {
        if (this.recorder == null || this.source == null || !this.source.hasUploadData() || StringUtils.isNullOrEmpty(this.source.recordKey)) {
            return;
        }
        try {
            JsonObject jsonObject = new JsonObject();
            JsonElement sourceJson = new Gson().toJsonTree((Object)this.source);
            if (sourceJson == null) {
                return;
            }
            jsonObject.add("source", sourceJson);
            JsonElement regionJson = new Gson().toJsonTree((Object)this.config.region.getCurrentRegion(new UploadToken(this.upToken)));
            if (regionJson == null) {
                return;
            }
            jsonObject.add("region", regionJson);
            String dataString = jsonObject.toString();
            this.recorder.set(this.source.recordKey, dataString.getBytes(Constants.UTF_8));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void removeUploadProgressFromLocal() {
        if (this.recorder == null || this.source == null || StringUtils.isNullOrEmpty(this.source.recordKey)) {
            return;
        }
        this.recorder.del(this.source.recordKey);
    }
}

