/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.storage.ApiUpload;
import com.qiniu.storage.ApiUtils;
import com.qiniu.storage.UploadToken;
import com.qiniu.util.StringUtils;

public class ApiUploadV2AbortUpload
extends ApiUpload {
    public ApiUploadV2AbortUpload(Client client) {
        super(client);
    }

    public ApiUploadV2AbortUpload(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends ApiUpload.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }
    }

    public static class Request
    extends ApiUpload.Request {
        private String key;
        private String uploadId;

        public Request(String urlPrefix, String token, String uploadId) {
            super(urlPrefix);
            this.setToken(token);
            this.setMethod(MethodType.DELETE);
            this.uploadId = uploadId;
        }

        public Request setKey(String key) {
            this.key = key;
            return this;
        }

        @Override
        protected void buildPath() throws QiniuException {
            UploadToken token = this.getUploadToken();
            if (token == null || !token.isValid()) {
                ApiUtils.throwInvalidRequestParamException("token");
            }
            if (StringUtils.isNullOrEmpty(this.uploadId)) {
                ApiUtils.throwInvalidRequestParamException("uploadId");
            }
            String bucket = token.getBucket();
            this.addPathSegment("buckets");
            this.addPathSegment(bucket);
            this.addPathSegment("objects");
            this.addPathSegment(ApiUtils.resumeV2EncodeKey(this.key));
            this.addPathSegment("uploads");
            this.addPathSegment(this.uploadId);
            super.buildPath();
        }
    }
}

