/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Api;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.HostProvider;
import com.qiniu.storage.Region;
import com.qiniu.storage.RegionGroup;
import com.qiniu.storage.RegionReqInfo;
import com.qiniu.util.Cache;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlSafeBase64;
import com.qiniu.util.UrlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class AutoRegion
extends Region {
    private List<String> ucServers = new ArrayList<String>();
    private Map<String, Region> regions;
    private static final Cache<UCRet> globalRegionCache = new Cache.Builder<UCRet>(UCRet.class).setVersion("v1").builder();
    private Client client;
    private int retryMax = 1;
    private int retryInterval = 300;
    private int hostFreezeDuration = 600000;

    private AutoRegion() {
    }

    AutoRegion(String ... ucServers) {
        this(1, 300, 600000, ucServers);
    }

    AutoRegion(int retryMax, int retryInterval, int hostFreezeDuration, String ... ucServers) {
        this.ucServers = ucServers != null && ucServers.length > 0 ? Arrays.asList(ucServers) : Arrays.asList(Configuration.defaultUcHosts);
        this.retryMax = retryMax;
        this.retryInterval = retryInterval;
        this.hostFreezeDuration = hostFreezeDuration;
        this.client = new Client();
        this.regions = new ConcurrentHashMap<String, Region>();
    }

    private UCRet queryRegionInfoFromServerIfNeeded(RegionIndex index) throws QiniuException {
        String cacheKey = this.getCacheId(index);
        UCRet ret = globalRegionCache.cacheForKey(cacheKey);
        if (ret != null && ret.isValid()) {
            return ret;
        }
        String[] ucHosts = this.getUcHostArray();
        String address = UrlUtils.setHostScheme(this.getUcServer(), true) + "/v3/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        Api api = new Api(this.client, new Api.Config.Builder().setSingleHostRetryMax(this.retryMax).setRetryInterval(this.retryInterval).setHostFreezeDuration(this.hostFreezeDuration).setHostRetryMax(ucHosts.length).setHostProvider(HostProvider.arrayProvider(ucHosts)).build());
        Response r = api.requestWithInterceptor(new Api.Request(address));
        ret = r.jsonToObject(UCRet.class);
        if (ret != null) {
            ret.setupDeadline();
            globalRegionCache.cache(cacheKey, ret);
        }
        return ret;
    }

    static Region regionGroup(UCRet ret) {
        if (ret == null || ret.hosts == null || ret.hosts.length == 0) {
            return null;
        }
        RegionGroup group = new RegionGroup();
        for (ServerRets host : ret.hosts) {
            Region region = host.createRegion();
            group.addRegion(region);
        }
        return group;
    }

    private Region queryRegionInfo(String accessKey, String bucket) throws QiniuException {
        RegionIndex index = new RegionIndex(accessKey, bucket);
        String cacheKey = this.getCacheId(index);
        Region region = this.regions.get(cacheKey);
        Exception ex = null;
        if (region == null || !region.isValid()) {
            for (int i = 0; i < 2; ++i) {
                try {
                    UCRet ret = this.queryRegionInfoFromServerIfNeeded(index);
                    region = AutoRegion.regionGroup(ret);
                    if (region == null) continue;
                    this.regions.put(cacheKey, region);
                    break;
                }
                catch (Exception e) {
                    ex = e;
                }
            }
        }
        if (region == null) {
            if (ex instanceof QiniuException) {
                throw (QiniuException)ex;
            }
            throw new QiniuException(ex, "auto region get region info from uc failed.");
        }
        return region;
    }

    private Region queryRegionInfo(RegionReqInfo regionReqInfo) throws QiniuException {
        return this.queryRegionInfo(regionReqInfo.getAccessKey(), regionReqInfo.getBucket());
    }

    @Override
    boolean switchRegion(RegionReqInfo regionReqInfo) {
        Region currentRegion = this.getCurrentRegion(regionReqInfo);
        if (currentRegion == null) {
            return false;
        }
        return currentRegion.switchRegion(regionReqInfo);
    }

    @Override
    String getRegion(RegionReqInfo regionReqInfo) {
        Region currentRegion = this.getCurrentRegion(regionReqInfo);
        if (currentRegion == null) {
            return "";
        }
        return currentRegion.getRegion(regionReqInfo);
    }

    @Override
    boolean isValid() {
        return true;
    }

    @Override
    Region getCurrentRegion(RegionReqInfo regionReqInfo) {
        try {
            Region region = this.queryRegionInfo(regionReqInfo);
            return region.getCurrentRegion(regionReqInfo);
        }
        catch (QiniuException e) {
            return null;
        }
    }

    @Override
    List<String> getSrcUpHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return null;
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getSrcUpHost(regionReqInfo);
    }

    @Override
    List<String> getAccUpHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return null;
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getAccUpHost(regionReqInfo);
    }

    @Override
    String getIovipHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getIovipHost(regionReqInfo);
    }

    @Override
    String getIoSrcHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getIoSrcHost(regionReqInfo);
    }

    @Override
    String getRsHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getRsHost(regionReqInfo);
    }

    @Override
    String getRsfHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getRsfHost(regionReqInfo);
    }

    @Override
    String getApiHost(RegionReqInfo regionReqInfo) throws QiniuException {
        if (regionReqInfo == null) {
            return "";
        }
        Region region = this.queryRegionInfo(regionReqInfo);
        return region.getApiHost(regionReqInfo);
    }

    @Override
    String getUcHost(RegionReqInfo regionReqInfo) throws QiniuException {
        String host = this.getUcServer();
        return UrlUtils.removeHostScheme(host);
    }

    String getUcServer() throws QiniuException {
        if (this.ucServers.size() == 0) {
            throw QiniuException.unrecoverable("AutoRegion not set uc host");
        }
        return this.ucServers.get(0);
    }

    @Override
    List<String> getUcHosts(RegionReqInfo regionReqInfo) throws QiniuException {
        if (this.ucServers.size() == 0) {
            throw QiniuException.unrecoverable("AutoRegion not set uc host");
        }
        ArrayList<String> newList = new ArrayList<String>();
        for (String host : this.ucServers) {
            String h = UrlUtils.removeHostScheme(host);
            if (StringUtils.isNullOrEmpty(h)) continue;
            newList.add(h);
        }
        return newList;
    }

    String[] getUcHostArray() throws QiniuException {
        return this.getUcHosts(null).toArray(new String[0]);
    }

    private String getCacheId(RegionIndex index) {
        StringBuilder builder = new StringBuilder().append(index.accessKey).append("-").append(index.bucket);
        if (this.ucServers != null && !this.ucServers.isEmpty()) {
            for (String host : this.ucServers) {
                if (host == null || host.isEmpty()) continue;
                builder.append(host);
            }
        }
        return UrlSafeBase64.encodeToString(builder.toString());
    }

    @Override
    public Object clone() {
        AutoRegion newRegion = new AutoRegion();
        newRegion.ucServers = new ArrayList<String>(this.ucServers);
        newRegion.regions = this.regions;
        newRegion.client = this.client;
        return newRegion;
    }

    private class HostInfoRet {
        List<String> main;
        List<String> backup;

        private HostInfoRet() {
        }

        private String getOneHost() {
            if (this.main != null && this.main.size() > 0) {
                return this.main.get(0);
            }
            if (this.backup != null && this.backup.size() > 0) {
                return this.backup.get(0);
            }
            return null;
        }

        private List<String> allHosts() {
            ArrayList<String> hosts = new ArrayList<String>();
            if (this.main != null && this.main.size() > 0) {
                hosts.addAll(this.main);
            }
            if (this.backup != null && this.backup.size() > 0) {
                hosts.addAll(this.backup);
            }
            return hosts;
        }
    }

    private class ServerRet {
        HostInfoRet src;
        HostInfoRet acc;

        private ServerRet() {
        }

        private String getOneHost() {
            String host = null;
            if (this.src != null) {
                host = this.src.getOneHost();
            }
            if (host == null && this.acc != null) {
                host = this.acc.getOneHost();
            }
            return host;
        }

        private List<String> allSrcHosts() {
            if (this.src != null) {
                return this.src.allHosts();
            }
            return new ArrayList<String>();
        }

        private List<String> allAccHosts() {
            if (this.acc != null) {
                return this.acc.allHosts();
            }
            return new ArrayList<String>();
        }
    }

    private class ServerRets {
        long ttl;
        String region;
        ServerRet up;
        ServerRet rs;
        ServerRet rsf;
        ServerRet uc;
        ServerRet api;
        ServerRet io;
        ServerRet io_src;

        private ServerRets() {
        }

        Region createRegion() {
            String regionId;
            long timestamp = this.ttl + System.currentTimeMillis() / 1000L;
            ArrayList<String> srcUpHosts = new ArrayList();
            ArrayList<String> accUpHosts = new ArrayList();
            if (this.up != null) {
                srcUpHosts = this.up.allSrcHosts();
                accUpHosts = this.up.allAccHosts();
            }
            String iovipHost = null;
            if (this.io != null) {
                iovipHost = this.io.getOneHost();
            }
            String ioSrcHost = null;
            if (this.io_src != null) {
                ioSrcHost = this.io_src.getOneHost();
            }
            String rsHost = null;
            if (this.rs != null) {
                rsHost = this.rs.getOneHost();
            }
            String rsfHost = null;
            if (this.rsf != null) {
                rsfHost = this.rsf.getOneHost();
            }
            String apiHost = null;
            if (this.api != null) {
                apiHost = this.api.getOneHost();
            }
            String ucHost = null;
            if (this.uc != null) {
                ucHost = this.uc.getOneHost();
            }
            if ((regionId = this.region) == null) {
                regionId = "";
            }
            return new Region(timestamp, regionId, srcUpHosts, accUpHosts, iovipHost, ioSrcHost, rsHost, rsfHost, apiHost, ucHost);
        }
    }

    private class UCRet {
        long deadline;
        ServerRets[] hosts;

        private UCRet() {
        }

        private boolean isValid() {
            return System.currentTimeMillis() < this.deadline * 1000L;
        }

        private void setupDeadline() {
            long ttl = Integer.MAX_VALUE;
            if (this.hosts != null && this.hosts.length > 0) {
                for (ServerRets hostRet : this.hosts) {
                    if (hostRet == null || hostRet.ttl >= ttl) continue;
                    ttl = hostRet.ttl;
                }
            }
            this.deadline = System.currentTimeMillis() / 1000L + ttl;
        }
    }

    private static class RegionIndex {
        private final String accessKey;
        private final String bucket;

        RegionIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof RegionIndex && ((RegionIndex)obj).accessKey.equals(this.accessKey) && ((RegionIndex)obj).bucket.equals(this.bucket);
        }
    }
}

