/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.storage.Api;
import com.qiniu.storage.ApiUtils;
import com.qiniu.storage.ConfigHelper;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.DownloadUrl;
import com.qiniu.util.StringUtils;

public class DownloadPrivateCloudUrl
extends DownloadUrl {
    private final Configuration cfg;
    private final String bucketName;
    private final String accessKey;

    public DownloadPrivateCloudUrl(String domain, boolean useHttps, String bucketName, String key, String accessKey) {
        super(domain, useHttps, key);
        this.cfg = null;
        this.bucketName = bucketName;
        this.accessKey = accessKey;
    }

    public DownloadPrivateCloudUrl(Configuration cfg, String bucketName, String key, String accessKey) {
        super(null, cfg.useHttpsDomains, key);
        this.cfg = cfg;
        this.bucketName = bucketName;
        this.accessKey = accessKey;
    }

    @Override
    protected void willBuildUrl() throws QiniuException {
        super.willBuildUrl();
        if (StringUtils.isNullOrEmpty(this.getDomain())) {
            this.setDomain(this.queryDomain());
        }
    }

    @Override
    protected void willSetKeyForUrl(Api.Request request) throws QiniuException {
        request.addPathSegment("getfile");
        request.addPathSegment(this.accessKey);
        request.addPathSegment(this.bucketName);
        super.willSetKeyForUrl(request);
    }

    private String queryDomain() throws QiniuException {
        ConfigHelper configHelper;
        String host;
        if (this.cfg == null) {
            ApiUtils.throwInvalidRequestParamException("configuration");
        }
        if (this.accessKey == null) {
            ApiUtils.throwInvalidRequestParamException("accessKey");
        }
        if (this.bucketName == null) {
            ApiUtils.throwInvalidRequestParamException("bucketName");
        }
        if (StringUtils.isNullOrEmpty(host = (configHelper = new ConfigHelper(this.cfg)).ioHost(this.accessKey, this.bucketName))) {
            return host;
        }
        if (host.contains("http://")) {
            return host.replaceFirst("http://", "");
        }
        if (host.contains("https://")) {
            return host.replaceFirst("https://", "");
        }
        return host;
    }
}

