/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.storage.Api;
import com.qiniu.storage.ApiUtils;
import com.qiniu.util.Auth;
import com.qiniu.util.StringUtils;
import com.qiniu.util.UrlUtils;
import java.util.ArrayList;
import java.util.List;

public class DownloadUrl {
    private String domain;
    private boolean useHttps = false;
    private String key;
    private Auth auth;
    private Long deadline;
    private String style;
    private String styleSeparator;
    private String styleParam;
    private String fop;
    private String attname;
    private List<Api.Request.Pair<String, String>> customQuerys = new ArrayList<Api.Request.Pair<String, String>>();

    public DownloadUrl(String domain, boolean useHttps, String key) {
        this.domain = domain;
        this.useHttps = useHttps;
        this.key = key;
    }

    protected void setDomain(String domain) {
        this.domain = domain;
    }

    protected String getDomain() {
        return this.domain;
    }

    public DownloadUrl setAttname(String attname) {
        this.attname = attname;
        return this;
    }

    public DownloadUrl setFop(String fop) {
        this.fop = fop;
        return this;
    }

    public DownloadUrl setStyle(String style, String styleSeparator, String styleParam) {
        this.style = style;
        this.styleSeparator = styleSeparator;
        this.styleParam = styleParam;
        return this;
    }

    public DownloadUrl addCustomQuery(String queryName, String queryValue) {
        this.customQuerys.add(new Api.Request.Pair<String, String>(queryName, queryValue));
        return this;
    }

    public String buildURL(Auth auth, long deadline) throws QiniuException {
        this.auth = auth;
        this.deadline = deadline;
        return this.buildURL();
    }

    public String buildURL() throws QiniuException {
        this.willBuildUrl();
        Api.Request request = new Api.Request(this.getUrlPrefix());
        this.willSetKeyForUrl(request);
        String keyAndStyle = null;
        keyAndStyle = this.urlPathEncode(this.key);
        if (!StringUtils.isNullOrEmpty(this.style) && !StringUtils.isNullOrEmpty(this.styleSeparator)) {
            keyAndStyle = keyAndStyle + this.urlPathEncode(this.styleSeparator + this.style);
            if (!StringUtils.isNullOrEmpty(this.styleParam)) {
                keyAndStyle = keyAndStyle + "@" + this.urlPathEncode(this.styleParam);
            }
        }
        if (!StringUtils.isNullOrEmpty(keyAndStyle)) {
            request.addPathSegment(keyAndStyle);
        }
        this.didSetKeyForUrl(request);
        if (!StringUtils.isNullOrEmpty(this.fop)) {
            request.addQueryPair(this.fop, null);
        }
        for (Api.Request.Pair<String, String> pair : this.customQuerys) {
            request.addQueryPair(pair.getKey(), pair.getValue());
        }
        if (!StringUtils.isNullOrEmpty(this.attname)) {
            request.addQueryPair("attname", this.attname);
        }
        this.didBuildUrl();
        String url = request.getUrl().toString();
        if (this.auth != null && this.deadline != null) {
            url = this.auth.privateDownloadUrlWithDeadline(url, this.deadline);
        }
        return url;
    }

    protected void willBuildUrl() throws QiniuException {
        if (this.key == null) {
            ApiUtils.throwInvalidRequestParamException("key");
        }
    }

    protected void willSetKeyForUrl(Api.Request request) throws QiniuException {
        if (StringUtils.isNullOrEmpty(this.domain)) {
            ApiUtils.throwInvalidRequestParamException("domain");
        }
    }

    protected void didSetKeyForUrl(Api.Request request) throws QiniuException {
    }

    protected void didBuildUrl() throws QiniuException {
    }

    private String getUrlPrefix() throws QiniuException {
        return UrlUtils.setHostScheme(this.domain, this.useHttps);
    }

    private String urlPathEncode(String path) {
        return UrlUtils.urlEncode(path, "/~");
    }
}

