/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.iam.apis;

import com.google.gson.annotations.SerializedName;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.Api;
import com.qiniu.util.Json;

public class ApiGetAudits
extends Api {
    public ApiGetAudits(Client client) {
        super(client);
    }

    public ApiGetAudits(Client client, Api.Config config) {
        super(client, config);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestWithInterceptor(request));
    }

    public static class Response
    extends Api.Response {
        private GetAuditLogsResp data;

        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
            this.data = Json.decode(response.bodyString(), GetAuditLogsResp.class);
        }

        public GetAuditLogsResp getData() {
            return this.data;
        }

        public static final class GetAuditLogsResp {
            @SerializedName(value="data")
            private GetAuditLogsData data;

            public GetAuditLogsData getData() {
                return this.data;
            }
        }

        public static final class GetAuditLogsData {
            @SerializedName(value="marker")
            private String marker;
            @SerializedName(value="list")
            private GetAuditLog[] list;

            public String getMarker() {
                return this.marker;
            }

            public GetAuditLog[] getList() {
                return this.list;
            }
        }

        public static final class GetAuditLog {
            @SerializedName(value="id")
            private String id;
            @SerializedName(value="root_uid")
            private Integer rootUid;
            @SerializedName(value="iuid")
            private Integer iuid;
            @SerializedName(value="service")
            private String service;
            @SerializedName(value="action")
            private String action;
            @SerializedName(value="created_at")
            private String createdAt;
            @SerializedName(value="event_time")
            private String eventTime;
            @SerializedName(value="duration_ms")
            private Integer durationMs;
            @SerializedName(value="source_ip")
            private String sourceIp;
            @SerializedName(value="user_event")
            private String userEvent;
            @SerializedName(value="error_code")
            private Integer errorCode;
            @SerializedName(value="error_message")
            private String errorMessage;

            public String getId() {
                return this.id;
            }

            public Integer getRootUid() {
                return this.rootUid;
            }

            public Integer getIuid() {
                return this.iuid;
            }

            public String getService() {
                return this.service;
            }

            public String getAction() {
                return this.action;
            }

            public String getCreatedAt() {
                return this.createdAt;
            }

            public String getEventTime() {
                return this.eventTime;
            }

            public Integer getDurationMs() {
                return this.durationMs;
            }

            public String getSourceIp() {
                return this.sourceIp;
            }

            public String getUserEvent() {
                return this.userEvent;
            }

            public Integer getErrorCode() {
                return this.errorCode;
            }

            public String getErrorMessage() {
                return this.errorMessage;
            }
        }
    }

    public static class Request
    extends Api.Request {
        private Integer iuid = null;
        private String service = null;
        private String action = null;
        private String resource = null;
        private String startTime = null;
        private String endTime = null;
        private String marker = null;
        private Integer limit = null;

        public Request(String urlPrefix) {
            super(urlPrefix);
            this.setMethod(MethodType.GET);
            this.setAuthType(1);
        }

        public Request setIuid(Integer iuid) {
            this.iuid = iuid;
            return this;
        }

        public Request setService(String service) {
            this.service = service;
            return this;
        }

        public Request setAction(String action) {
            this.action = action;
            return this;
        }

        public Request setResource(String resource) {
            this.resource = resource;
            return this;
        }

        public Request setStartTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public Request setEndTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Request setMarker(String marker) {
            this.marker = marker;
            return this;
        }

        public Request setLimit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        protected void prepareToRequest() throws QiniuException {
            super.prepareToRequest();
        }

        @Override
        protected void buildPath() throws QiniuException {
            this.addPathSegment("iam/v1/audits");
            super.buildPath();
        }

        @Override
        protected void buildQuery() throws QiniuException {
            if (this.iuid != null) {
                this.addQueryPair("iuid", this.iuid);
            }
            if (this.service != null) {
                this.addQueryPair("service", this.service);
            }
            if (this.action != null) {
                this.addQueryPair("action", this.action);
            }
            if (this.resource != null) {
                this.addQueryPair("resource", this.resource);
            }
            if (this.startTime != null) {
                this.addQueryPair("start_time", this.startTime);
            }
            if (this.endTime != null) {
                this.addQueryPair("end_time", this.endTime);
            }
            if (this.marker != null) {
                this.addQueryPair("marker", this.marker);
            }
            if (this.limit != null) {
                this.addQueryPair("limit", this.limit);
            }
            super.buildQuery();
        }

        @Override
        protected void buildHeader() throws QiniuException {
            super.buildHeader();
        }

        @Override
        protected void buildBodyInfo() throws QiniuException {
            super.buildBodyInfo();
        }
    }
}

