/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.admin.feign;

import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.admin.security.SecurityUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class AdminFeignClientInterceptor
implements RequestInterceptor {
    private static final String FEIGN_TRACE_ID = "Feign-Trace-Id";
    private static final String TRACE_ID = "traceId";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";

    public void apply(RequestTemplate template) {
        Optional<String> optional = SecurityUtils.getCurrentUserJWT();
        if (optional.isPresent()) {
            template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER, optional.get())});
            template.header(FEIGN_TRACE_ID, new String[]{MDC.get((String)TRACE_ID)});
        } else {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                String token = request.getHeader(AUTHORIZATION_HEADER);
                template.header(AUTHORIZATION_HEADER, new String[]{token});
                template.header(FEIGN_TRACE_ID, new String[]{MDC.get((String)TRACE_ID)});
            } else {
                JSONObject json;
                String token;
                Object object;
                String requestBody;
                Optional options;
                Collection list;
                Map objects = template.request().headers();
                if (!CollectionUtils.isEmpty((Map)objects) && !CollectionUtils.isEmpty((Collection)(list = (Collection)objects.get(AUTHORIZATION_HEADER))) && (options = list.stream().findFirst()).isPresent()) {
                    template.header(AUTHORIZATION_HEADER, new String[]{(String)options.get()});
                    template.header(FEIGN_TRACE_ID, new String[]{MDC.get((String)TRACE_ID)});
                }
                if ((template.headers().isEmpty() || ((Collection)template.headers().get(AUTHORIZATION_HEADER)).isEmpty()) && template.body() != null && !StringUtils.isEmpty((Object)(requestBody = template.body().toString())) && (object = JSONObject.parse((String)requestBody)) instanceof JSONObject && !StringUtils.isEmpty((Object)(token = (json = (JSONObject)object).getString("token")))) {
                    template.header(AUTHORIZATION_HEADER, new String[]{token});
                    template.header(FEIGN_TRACE_ID, new String[]{MDC.get((String)TRACE_ID)});
                }
            }
        }
    }
}

