/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.facade.mapper;

import com.qqt.platform.common.domain.AbstractCompanyEntity;
import com.qqt.platform.common.domain.IAuditingEntity;
import com.qqt.platform.common.dto.CompanyDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.service.dto.AbstractAuditingDTO;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.MappingTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;

public abstract class AuditingDTOMapper<DTO extends AbstractAuditingDTO, Entity extends IAuditingEntity> {
    private static final Logger logger = LoggerFactory.getLogger(AuditingDTOMapper.class);
    @Autowired
    private AdminFeignService adminFeignService;

    public abstract Entity toEntity(DTO var1);

    @AfterMapping
    protected void fillAuditing(Entity auditingEntity, @MappingTarget DTO auditingDTO) {
        ResultDTO resultDTO;
        String code;
        ResponseEntity<ResultDTO<UserDetailDO>> userEntity;
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{auditingEntity.getCreatedBy()}) && (userEntity = this.adminFeignService.getUserDetailByCode(code = auditingEntity.getCreatedBy(), new String[]{"basic"})) != null && userEntity.getBody() != null && (resultDTO = (ResultDTO)userEntity.getBody()).getData() != null) {
                ((AbstractAuditingDTO)auditingDTO).setCreatedName(((UserDetailDO)resultDTO.getData()).getNameCn());
            }
        }
        catch (Exception e) {
            logger.error("getUserDetailByCode CreatedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
        }
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{auditingEntity.getLastModifiedBy()}) && (userEntity = this.adminFeignService.getUserDetailByCode(code = auditingEntity.getLastModifiedBy(), new String[]{"basic"})) != null && userEntity.getBody() != null && (resultDTO = (ResultDTO)userEntity.getBody()).getData() != null) {
                ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(((UserDetailDO)resultDTO.getData()).getNameCn());
            }
        }
        catch (Exception e) {
            logger.error("getUserDetailByCode LastModifiedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
        }
        if (auditingEntity instanceof AbstractCompanyEntity) {
            try {
                ResultDTO resultDO;
                Long companyId;
                ResponseEntity<ResultDTO<CompanyDO>> companyDOEntity;
                AbstractCompanyEntity companyEntity = (AbstractCompanyEntity)auditingEntity;
                if (companyEntity.getCompanyId() != null && companyEntity.getCompanyId() > 0L && (companyDOEntity = this.adminFeignService.getCompanyById(companyId = companyEntity.getCompanyId(), new String[0])) != null && companyDOEntity.getBody() != null && (resultDO = (ResultDTO)companyDOEntity.getBody()).getData() != null) {
                    CompanyDO companyDO = (CompanyDO)resultDO.getData();
                    ((AbstractAuditingDTO)auditingDTO).setCompanyId(companyDO.getId());
                    ((AbstractAuditingDTO)auditingDTO).setCompanyCode(companyDO.getCode());
                    ((AbstractAuditingDTO)auditingDTO).setCompanyName(companyDO.getName());
                    logger.debug("companyDO,Code:{},Name:{}", (Object)companyDO.getCode(), (Object)companyDO.getName());
                }
            }
            catch (Exception e) {
                logger.error("getUserDetailByCode LastModifiedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
            }
        }
    }

    public abstract DTO toDto(Entity var1);

    public abstract List<Entity> toEntity(List<DTO> var1);

    public abstract List<DTO> toDto(List<Entity> var1);
}

