/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.facade.impl;

import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.exception.BaseAssert;
import com.qqt.platform.common.facade.BaseFacade;
import com.qqt.platform.common.facade.UserDetailFacade;
import com.qqt.platform.common.feign.AdminFeignService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class UserDetailFacadeImpl
extends BaseFacade
implements UserDetailFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailFacadeImpl.class);
    @Autowired
    private AdminFeignService adminFeignService;

    @Override
    public UserDetailDO getUserDetailById(Long userId) {
        BaseAssert.isTrue(userId != null, this.getMsg("user.query.idisnull"));
        ResponseEntity<ResultDTO<UserDetailDO>> userEntity = this.adminFeignService.getUserDetailById(userId, new String[]{"basic", "company", "department", "userGroup", "userGroup", "role"});
        ResultDTO resultDTO = (ResultDTO)userEntity.getBody();
        BaseAssert.isTrue(userEntity != null && resultDTO != null, this.getMsg("user.query.resultisnull", new Object[]{userId}));
        BaseAssert.isTrue(resultDTO.isSuccess(), resultDTO.getMsg());
        UserDetailDO userDetailDO = (UserDetailDO)resultDTO.getData();
        BaseAssert.isTrue(userDetailDO.getLogin() != null, this.getMsg("user.query.userisnull", new Object[]{userId}));
        BaseAssert.isTrue(userDetailDO.getCompanyDO() != null, this.getMsg("user.query.companyisnull", new Object[]{userDetailDO.getLogin()}));
        return userDetailDO;
    }

    @Override
    public UserDetailDO getUserDetailByCode(String userCode) {
        BaseAssert.isTrue(userCode != null, this.getMsg("user.query.codeisnull"));
        ResponseEntity<ResultDTO<UserDetailDO>> userEntity = this.adminFeignService.getUserDetailByCode(userCode, new String[]{"basic", "company", "department", "userGroup", "userGroup", "role"});
        ResultDTO resultDTO = (ResultDTO)userEntity.getBody();
        BaseAssert.isTrue(userEntity != null && resultDTO != null, this.getMsg("user.query.resultisnull", new Object[]{userCode}));
        BaseAssert.isTrue(resultDTO.isSuccess(), resultDTO.getMsg());
        UserDetailDO userDetailDO = (UserDetailDO)resultDTO.getData();
        BaseAssert.isTrue(userDetailDO.getLogin() != null, this.getMsg("user.query.userisnull", new Object[]{userCode}));
        BaseAssert.isTrue(userDetailDO.getCompanyDO() != null, this.getMsg("user.query.companyisnull", new Object[]{userDetailDO.getLogin()}));
        return userDetailDO;
    }
}

