/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.service;

import com.qqt.platform.common.security.SecurityUtils;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class SessionService {
    @Autowired
    private RedisTemplate redisTemplate;
    private Logger logger = LoggerFactory.getLogger(SessionService.class);
    private Long userId;
    private String userCode;
    private String siteCode;
    private Long siteId;
    private Long storeId;
    private Long companyId;
    private Long currencyId;
    private Long languageId;
    private String storeCode;
    private String languageCode;
    private String companyCode;
    private String companyName;
    private Long departmentId;

    private void getSessionInfo() {
        String tokenKey = "JWT_TOKEN_DATA_" + SecurityUtils.getCurrentUserJWT();
        this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
        boolean hasJwtToken = this.redisTemplate.hasKey((Object)tokenKey);
        if (hasJwtToken) {
            this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
            Map sessionDataMap = this.redisTemplate.opsForHash().entries((Object)tokenKey);
            if (sessionDataMap != null) {
                if (sessionDataMap.containsKey("userId")) {
                    this.userId = (Long)sessionDataMap.get("userId");
                }
                if (sessionDataMap.containsKey("userCode")) {
                    this.userCode = (String)sessionDataMap.get("userCode");
                }
                if (sessionDataMap.containsKey("siteCode")) {
                    this.siteCode = (String)sessionDataMap.get("siteCode");
                }
                if (sessionDataMap.containsKey("companyCode")) {
                    this.companyCode = (String)sessionDataMap.get("companyCode");
                }
                if (sessionDataMap.containsKey("companyName")) {
                    this.companyName = (String)sessionDataMap.get("companyName");
                }
                if (sessionDataMap.containsKey("languageCode")) {
                    this.languageCode = (String)sessionDataMap.get("languageCode");
                }
                if (sessionDataMap.containsKey("storeCode")) {
                    this.storeCode = (String)sessionDataMap.get("storeCode");
                }
                if (sessionDataMap.containsKey("siteId")) {
                    this.siteId = (Long)sessionDataMap.get("siteId");
                }
                if (sessionDataMap.containsKey("storeId")) {
                    this.storeId = (Long)sessionDataMap.get("storeId");
                }
                if (sessionDataMap.containsKey("companyId")) {
                    this.companyId = (Long)sessionDataMap.get("companyId");
                }
                if (sessionDataMap.containsKey("currencyId")) {
                    this.currencyId = (Long)sessionDataMap.get("currencyId");
                }
                if (sessionDataMap.containsKey("languageId")) {
                    this.languageId = (Long)sessionDataMap.get("languageId");
                }
                if (sessionDataMap.containsKey("departmentId")) {
                    this.departmentId = (Long)sessionDataMap.get("departmentId");
                }
            }
        }
    }

    private <T> T getInfo(String key) {
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        T info = null;
        if (jwtOpt.isPresent()) {
            String tokenKey = "JWT_TOKEN_DATA_" + jwtOpt.get().hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            boolean hasJwtToken = this.redisTemplate.hasKey((Object)tokenKey);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                Map sessionDataMap = this.redisTemplate.opsForHash().entries((Object)tokenKey);
                if (sessionDataMap != null && sessionDataMap.containsKey(key)) {
                    info = (T)sessionDataMap.get(key);
                }
            }
        }
        if (info == null) {
            // empty if block
        }
        return info;
    }

    public Long getCurrentUserId() {
        return (Long)this.getInfo("userId");
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getCurrentUserCode() {
        return (String)this.getInfo("userCode");
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getCurrentSiteCode() {
        return (String)this.getInfo("siteCode");
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getCurrentStoreCode() {
        return (String)this.getInfo("storeCode");
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getCurrentLanguageCode() {
        return (String)this.getInfo("languageCode");
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getCurrentCompanyCode() {
        return (String)this.getInfo("companyCode");
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getCurrentCompanyName() {
        return (String)this.getInfo("companyName");
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Long getSiteId() {
        return (Long)this.getInfo("siteId");
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public Long getStoreId() {
        if (this.getCompanyId() == 15L) {
            return 11L;
        }
        return (Long)this.getInfo("storeId");
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public Long getCompanyId() {
        return (Long)this.getInfo("companyId");
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public Long getCurrencyId() {
        return (Long)this.getInfo("currencyId");
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public Long getLanguageId() {
        return (Long)this.getInfo("languageId");
    }

    public void setLanguageId(Long languageId) {
        this.languageId = languageId;
    }

    public Long getDepartmentId() {
        return (Long)this.getInfo("departmentId");
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
}

