/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.facade.impl;

import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.message.MessageBodyDTO;
import com.qqt.platform.common.dto.message.UserTargetDTO;
import com.qqt.platform.common.facade.BaseFacade;
import com.qqt.platform.common.facade.MessageRecevierProvide;
import com.qqt.platform.common.facade.MessageSendFacade;
import com.qqt.platform.common.feign.AdminMessageFeignService;
import com.qqt.platform.common.utils.ResultUtil;
import com.qqt.platform.tool.utils.CollectionUtil;
import com.qqt.platform.tool.utils.StringUtil;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class MessageSendFacadeImpl
extends BaseFacade
implements MessageSendFacade {
    private static final Logger log = LoggerFactory.getLogger(MessageSendFacadeImpl.class);
    @Autowired
    private AdminMessageFeignService adminMessageFeignService;

    @Override
    public ResultDTO sendMsg(MessageBodyDTO messageBody) {
        log.debug("\u53d1\u9001\u6d88\u606f\u53c2\u6570\uff1a{}", (Object)messageBody);
        ResultDTO<Set<UserTargetDTO>> resultDTO = this.getReceivers(messageBody);
        if (!resultDTO.isSuccess()) {
            return resultDTO;
        }
        messageBody.setUserTargets(resultDTO.getData());
        ResponseEntity<ResultDTO> responseEntity = this.adminMessageFeignService.sendMsg(messageBody);
        if (responseEntity == null || responseEntity.getBody() == null) {
            log.warn("sendMsg result is null,params:{}", (Object)messageBody);
            return ResultUtil.fail("sendMsg result is null");
        }
        return (ResultDTO)responseEntity.getBody();
    }

    private ResultDTO<Set<UserTargetDTO>> getReceivers(MessageBodyDTO messageBody) {
        if (messageBody == null) {
            log.warn("getRecevierList sendMsg params is null");
            return ResultUtil.fail("sendMsg params is null");
        }
        if (StringUtil.isBlank((CharSequence)messageBody.getRecevierConfigCode()) && messageBody.getCustomizeRecevierProvideBean() == null) {
            log.warn("getRecevierList sendMsg configCode and provideBean is null");
            return ResultUtil.fail("configCode and provideBean is null");
        }
        if (messageBody.getCustomizeRecevierProvideBean() != null) {
            MessageRecevierProvide provideBean = messageBody.getCustomizeRecevierProvideBean();
            ResultDTO<Set<UserTargetDTO>> result = provideBean.getRecevierList(messageBody.getBillRelations());
            if (result.isSuccess() && CollectionUtils.isNotEmpty((Collection)result.getData())) {
                return result;
            }
            if (StringUtil.isNotBlank((CharSequence)messageBody.getRecevierConfigCode())) {
                return this.readUserTargetsByConfig(messageBody);
            }
            log.warn("getRecevierList error:{},params:{}", (Object)result.getMsg(), (Object)messageBody);
            return result;
        }
        return this.readUserTargetsByConfig(messageBody);
    }

    private ResultDTO<Set<UserTargetDTO>> readUserTargetsByConfig(MessageBodyDTO messageBody) {
        ResponseEntity<ResultDTO<Set<UserTargetDTO>>> targets = this.adminMessageFeignService.getUserTargetsByConfig(messageBody);
        ResultDTO resultDTO = (ResultDTO)targets.getBody();
        if (targets == null || resultDTO == null) {
            log.warn("readUserTargetsByConfig recevierConfig query result is null");
            return ResultUtil.fail("recevierConfig query result is null");
        }
        ResultDTO body = (ResultDTO)targets.getBody();
        if (!body.isSuccess()) {
            log.warn("readUserTargetsByConfig error:{},params:{}", (Object)body.getMsg(), (Object)messageBody);
            return body;
        }
        if (CollectionUtil.isEmpty((Collection)((Collection)body.getData()))) {
            log.warn("readUserTargetsByConfig error:{},params:{},recevierConfig query data is null", (Object)body.getMsg(), (Object)messageBody);
            return ResultUtil.fail("recevierConfig query data is null");
        }
        return body;
    }
}

