/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import javax.cache.Cache;
import javax.cache.configuration.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.redisson.jcache.JCacheManager;
import org.redisson.jcache.configuration.RedissonConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JCacheManagerUtils {
    @Autowired
    JCacheManager jCacheManager;
    @Autowired
    RedissonConfiguration redissonConfiguration;

    public Cache<Object, Object> getCacheByCacheNameOrType(String cacheName, Class type) {
        Cache cacheData = null;
        if (this.jCacheManager != null && this.redissonConfiguration != null) {
            if (StringUtils.isEmpty((CharSequence)cacheName) && type == null) {
                return null;
            }
            cacheData = StringUtils.isEmpty((CharSequence)cacheName) ? this.jCacheManager.getCache(type.getName()) : this.jCacheManager.getCache(cacheName);
            if (cacheData == null) {
                cacheData = StringUtils.isEmpty((CharSequence)cacheName) ? this.jCacheManager.createCache(type.getName(), (Configuration)this.redissonConfiguration) : this.jCacheManager.createCache(cacheName, (Configuration)this.redissonConfiguration);
            }
            return cacheData;
        }
        return null;
    }

    public Cache<Object, Object> getCacheByKey(String key) {
        Cache cacheData = null;
        if (this.jCacheManager != null && this.redissonConfiguration != null) {
            if (StringUtils.isEmpty((CharSequence)key)) {
                return null;
            }
            cacheData = this.jCacheManager.getCache(key);
            if (cacheData == null) {
                cacheData = this.jCacheManager.createCache(key, (Configuration)this.redissonConfiguration);
            }
            return cacheData;
        }
        return null;
    }
}

