/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.qqt.platform.common.dto.DataOperateLogDTO;
import com.qqt.platform.common.dto.ModifiedProperty;
import com.qqt.platform.common.event.DataOperateLogPublisher;
import com.qqt.platform.common.utils.CompareObjectPropertyUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class DataOperateInterceptor
implements HandlerInterceptor {
    @PersistenceContext
    private EntityManager entityManager;
    private Logger log = LoggerFactory.getLogger(DataOperateInterceptor.class);
    private final String[] methods = new String[]{"save", "deleteById", "delete", "deleteAll"};
    private final String[] ignoreClazz = new String[]{"LogApi", "LogError", "LogUsual", "DataOperateLog"};
    private final String crudPoint = "execution(* org.springframework.data.repository.*.*(..))";

    @Pointcut(value="execution(* org.springframework.data.repository.*.*(..))")
    public void executeService() {
    }

    @Before(value="executeService()")
    public void doBeforeMethod(JoinPoint joinPoint) {
        this.log.debug("\u524d\u7f6e\u901a\u77e5\uff0c\u5c06\u8981\u6267\u884c\u4e00\u4e2a\u65b9\u6cd5\u4e86");
        Class clazz = joinPoint.getSignature().getDeclaringType();
        if (!clazz.getSimpleName().equals("CrudRepository")) {
            return;
        }
        Object[] args = joinPoint.getArgs();
        if (null == args) {
            return;
        }
        String method = joinPoint.getSignature().getName();
        this.log.debug("current method:{}", (Object)method);
        if (!Arrays.asList(this.methods).contains(method)) {
            return;
        }
        Object arg = args[0];
        Class<?> argClazz = arg.getClass();
        if (Arrays.asList(this.ignoreClazz).contains(argClazz.getSimpleName())) {
            this.log.info("ignore class:{}", (Object)clazz.getSimpleName());
            return;
        }
        if (method.equals("deleteById") && argClazz.getSimpleName().equals(Long.class.getSimpleName())) {
            return;
        }
        if (method.equals("deleteAll") && argClazz.getSimpleName().equals(Iterable.class.getSimpleName())) {
            Iterable iterable = (Iterable)arg;
            Object obj = iterable.iterator().next();
            argClazz = obj.getClass();
            List<Object> ids = this.getEntityId(iterable);
            DataOperateLogDTO dto = new DataOperateLogDTO();
            dto.setOperateType("DELETE");
            dto.setClassName(argClazz.getName());
            dto.setCreateTime(new Date());
            dto.setRecord(JSON.toJSONString(ids));
            DataOperateLogPublisher.publishEvent(dto);
            return;
        }
        Object id = this.getEntityId(arg, argClazz);
        if (id == null) {
            return;
        }
        if (arg instanceof HibernateProxy) {
            HibernateProxy hibernateProxy = (HibernateProxy)arg;
            LazyInitializer initializer = hibernateProxy.getHibernateLazyInitializer();
            arg = initializer.getImplementation();
            argClazz = arg.getClass();
        }
        this.log.debug("arg type:{}", (Object)arg.getClass().getName());
        this.log.debug("arg:{}", arg);
        if (method.startsWith("save")) {
            Object original = this.entityManager.find(argClazz, id);
            if (null != original) {
                if (original instanceof HibernateProxy) {
                    HibernateProxy hibernateProxy = (HibernateProxy)original;
                    LazyInitializer initializer = hibernateProxy.getHibernateLazyInitializer();
                    original = initializer.getImplementation();
                }
                DataOperateLogDTO dto = new DataOperateLogDTO();
                dto.setOperateType("UPDATE");
                dto.setClassName(argClazz.getName());
                dto.setEntityId(String.valueOf(id));
                dto.setCreateTime(new Date());
                List<ModifiedProperty> list = CompareObjectPropertyUtil.getDifferentProperty(original, arg, new String[0]);
                dto.setRecord(JSON.toJSONString(list, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.WriteMapNullValue}));
                DataOperateLogPublisher.publishEvent(dto);
            }
        } else {
            DataOperateLogDTO dto = new DataOperateLogDTO();
            dto.setOperateType("DELETE");
            dto.setClassName(argClazz.getName());
            dto.setEntityId(String.valueOf(id));
            dto.setCreateTime(new Date());
            dto.setRecord(JSON.toJSONString((Object)arg));
            DataOperateLogPublisher.publishEvent(dto);
        }
    }

    private Object getEntityId(Object arg, Class argClazz) {
        Method[] mds = argClazz.getDeclaredMethods();
        Method getId = null;
        for (Method m : mds) {
            if (!m.getName().equals("getId")) continue;
            getId = m;
            break;
        }
        if (null == getId) {
            return null;
        }
        Object id = null;
        try {
            id = getId.invoke(arg, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return id;
    }

    private List<Object> getEntityId(Iterable iterable) {
        Object obj = iterable.iterator().next();
        Class<?> argClazz = obj.getClass();
        Method[] mds = argClazz.getDeclaredMethods();
        Method getId = null;
        for (Method m : mds) {
            if (!m.getName().equals("getId")) continue;
            getId = m;
            break;
        }
        if (null == getId) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        Method finalGetId = getId;
        iterable.forEach(item -> {
            try {
                list.add(finalGetId.invoke(item, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        });
        return list;
    }
}

