/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.event;

import com.qqt.platform.common.config.ServerConfiguration;
import com.qqt.platform.common.dto.LogApiDTO;
import com.qqt.platform.common.event.ApiLogEvent;
import com.qqt.platform.common.feign.AdminLogFeignService;
import com.qqt.platform.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ApiLogListener {
    private static final Logger log = LoggerFactory.getLogger(ApiLogListener.class);
    private final AdminLogFeignService logService;
    private final ServerConfiguration serverConfiguration;
    private final Environment environment;
    private final JHipsterProperties jHipsterProperties;

    @Async
    @Order
    @EventListener(value={ApiLogEvent.class})
    public void saveApiLog(ApiLogEvent event) {
        Map source = (Map)event.getSource();
        LogApiDTO logApiDTO = (LogApiDTO)source.get("info");
        LogAbstractUtil.addOtherInfoToLog(logApiDTO, this.jHipsterProperties, this.environment, this.serverConfiguration);
        this.logService.saveApiLog(logApiDTO);
    }

    public ApiLogListener(AdminLogFeignService logService, ServerConfiguration serverConfiguration, Environment environment, JHipsterProperties jHipsterProperties) {
        this.logService = logService;
        this.serverConfiguration = serverConfiguration;
        this.environment = environment;
        this.jHipsterProperties = jHipsterProperties;
    }
}

