/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.client;

import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.common.security.SecurityUtils;
import com.qqt.platform.tool.utils.StringUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CommonFeignClientInterceptor
implements RequestInterceptor {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER = "Bearer";

    public void apply(RequestTemplate template) {
        Optional<String> optional = SecurityUtils.getCurrentUserJWT();
        if (optional.isPresent()) {
            template.header(AUTHORIZATION_HEADER, new String[]{String.format("%s %s", BEARER, optional.get())});
        } else {
            JSONObject json;
            String token;
            String requestBody = template.requestBody().asString();
            if (!StringUtil.isEmpty((Object)requestBody) && !StringUtil.isEmpty((Object)(token = (json = JSONObject.parseObject((String)requestBody)).getString("token")))) {
                template.header(AUTHORIZATION_HEADER, new String[]{token});
            }
        }
    }
}

