/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.qqt.platform.common.dto.ModifiedProperty;
import com.qqt.platform.common.dto.PropertyModel;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CompareObjectPropertyUtil {
    private static final Logger log = LoggerFactory.getLogger(CompareObjectPropertyUtil.class);

    public static <T> List<ModifiedProperty> getDifferentProperty(T oldObj, T newObj, String ... ignoreProperties) {
        if (!oldObj.getClass().equals(newObj.getClass())) {
            return Collections.emptyList();
        }
        if (oldObj == null || newObj == null) {
            return Collections.emptyList();
        }
        if ((ignoreProperties == null || ignoreProperties.length > 0) && oldObj.equals(newObj)) {
            return Collections.emptyList();
        }
        List<PropertyModel> oldObjectPropertyValue = CompareObjectPropertyUtil.getObjectPropertyValue(oldObj, ignoreProperties);
        if (!CollectionUtils.isEmpty(oldObjectPropertyValue)) {
            Object value;
            String propertyName;
            ArrayList<ModifiedProperty> modifiedProperties = new ArrayList<ModifiedProperty>(oldObjectPropertyValue.size());
            List<PropertyModel> newObjectPropertyValue = CompareObjectPropertyUtil.getObjectPropertyValue(newObj, ignoreProperties);
            HashMap<String, Object> objectMap = new HashMap<String, Object>(newObjectPropertyValue.size());
            for (PropertyModel PropertyModel2 : newObjectPropertyValue) {
                propertyName = PropertyModel2.getPropertyName();
                value = PropertyModel2.getValue();
                objectMap.put(propertyName, value);
            }
            for (PropertyModel PropertyModel2 : oldObjectPropertyValue) {
                propertyName = PropertyModel2.getPropertyName();
                value = PropertyModel2.getValue();
                if (!objectMap.containsKey(propertyName)) continue;
                Object newValue = objectMap.get(propertyName);
                ModifiedProperty ModifiedProperty2 = new ModifiedProperty();
                if (value != null && newValue != null) {
                    if (value.equals(newValue)) continue;
                    ModifiedProperty2.setPropertyName(propertyName);
                    ModifiedProperty2.setOriginalValue(value);
                    ModifiedProperty2.setValue(newValue);
                    modifiedProperties.add(ModifiedProperty2);
                    continue;
                }
                if ((newValue != null || value == null || StringUtils.isEmpty((Object)value.toString())) && (value != null || newValue == null || StringUtils.isEmpty((Object)newValue.toString()))) continue;
                ModifiedProperty2.setPropertyName(propertyName);
                ModifiedProperty2.setOriginalValue(value);
                ModifiedProperty2.setValue(newValue);
                modifiedProperties.add(ModifiedProperty2);
            }
            return modifiedProperties;
        }
        return Collections.emptyList();
    }

    private static <T> List<PropertyModel> getObjectPropertyValue(T obj, String ... ignoreProperties) {
        if (obj != null) {
            Class<?> objClass = obj.getClass();
            PropertyDescriptor[] propertyDescriptors = BeanUtils.getPropertyDescriptors(objClass);
            ArrayList<PropertyModel> modelInfos = new ArrayList<PropertyModel>(propertyDescriptors.length);
            Field[] fields = objClass.getDeclaredFields();
            List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
            for (Field field : fields) {
                if (field.getName().equals("serialVersionUID")) continue;
                field.setAccessible(true);
                String fieldName = field.getName();
                if (ignoreList != null && ignoreList.contains(fieldName)) continue;
                PropertyModel PropertyModel2 = new PropertyModel();
                PropertyModel2.setPropertyName(fieldName);
                PropertyModel2.setReturnType(field.getType());
                Object fieldValue = CompareObjectPropertyUtil.getFieldValueByName(field, obj);
                PropertyModel2.setValue(fieldValue == null ? "" : fieldValue);
                modelInfos.add(PropertyModel2);
            }
            return modelInfos;
        }
        return Collections.emptyList();
    }

    private static Object getFieldValueByName(Field field, Object o) {
        try {
            String fieldName = field.getName();
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            Class<?> clazz = field.getType();
            String prefix = "get";
            if (clazz.getSimpleName().equalsIgnoreCase(Boolean.class.getSimpleName())) {
                prefix = "is";
            }
            String getter = prefix + firstLetter + fieldName.substring(1);
            Method method = o.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke(o, new Object[0]);
            return value;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

