/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.facade.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.UserDTO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.exception.BaseAssert;
import com.qqt.platform.common.facade.BaseFacade;
import com.qqt.platform.common.facade.UserDetailFacade;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.utils.JCacheManagerUtils;
import javax.cache.Cache;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class UserDetailFacadeImpl
extends BaseFacade
implements UserDetailFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailFacadeImpl.class);
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    private JCacheManagerUtils jCacheManagerUtils;

    @Override
    public UserDetailDO getUserDetailById(Long userId) {
        BaseAssert.isTrue(userId != null, this.getMsg("user.query.idisnull"));
        ResponseEntity<ResultDTO<UserDetailDO>> userEntity = this.adminFeignService.getUserDetailById(userId, new String[]{"basic", "company", "department", "userGroup", "userGroup", "role"});
        ResultDTO resultDTO = (ResultDTO)userEntity.getBody();
        BaseAssert.isTrue(userEntity != null && resultDTO != null, this.getMsg("user.query.resultisnull", new Object[]{userId}));
        BaseAssert.isTrue(resultDTO.isSuccess(), resultDTO.getMsg());
        UserDetailDO userDetailDO = (UserDetailDO)resultDTO.getData();
        BaseAssert.isTrue(userDetailDO.getLogin() != null, this.getMsg("user.query.userisnull", new Object[]{userId}));
        BaseAssert.isTrue(userDetailDO.getCompanyDO() != null, this.getMsg("user.query.companyisnull", new Object[]{userDetailDO.getLogin()}));
        return userDetailDO;
    }

    @Override
    public UserDetailDO getUserDetailByCode(String userCode) {
        BaseAssert.isTrue(userCode != null, this.getMsg("user.query.codeisnull"));
        ResponseEntity<ResultDTO<UserDetailDO>> userEntity = this.adminFeignService.getUserDetailByCode(userCode, new String[]{"basic", "company", "department", "userGroup", "userGroup", "role"});
        ResultDTO resultDTO = (ResultDTO)userEntity.getBody();
        BaseAssert.isTrue(userEntity != null && resultDTO != null, this.getMsg("user.query.resultisnull", new Object[]{userCode}));
        BaseAssert.isTrue(resultDTO.isSuccess(), resultDTO.getMsg());
        UserDetailDO userDetailDO = (UserDetailDO)resultDTO.getData();
        BaseAssert.isTrue(userDetailDO.getLogin() != null, this.getMsg("user.query.userisnull", new Object[]{userCode}));
        BaseAssert.isTrue(userDetailDO.getCompanyDO() != null, this.getMsg("user.query.companyisnull", new Object[]{userDetailDO.getLogin()}));
        return userDetailDO;
    }

    @Override
    public String getUserNameById(Long userId) {
        Cache<Object, Object> userDataCache = this.jCacheManagerUtils.getCacheByKey("com.qqt.platform.admin.domain.User");
        ObjectMapper objectMapper = new ObjectMapper();
        UserDTO userDTO = null;
        if (userDataCache != null && userDataCache.containsKey((Object)userId) && userDataCache.get((Object)userId) != null) {
            userDTO = (UserDTO)objectMapper.convertValue(userDataCache.get((Object)userId), UserDTO.class);
        }
        if (userDTO != null) {
            return userDTO.getNameCn();
        }
        try {
            ResultDTO resultDTO;
            ResponseEntity<ResultDTO<UserDTO>> userEntity = this.adminFeignService.getUserById(userId);
            if (userEntity != null && userEntity.getBody() != null && ((ResultDTO)userEntity.getBody()).getData() != null && (resultDTO = (ResultDTO)userEntity.getBody()).getData() != null && StringUtils.isNotBlank((CharSequence)((UserDTO)resultDTO.getData()).getNameCn())) {
                return ((UserDTO)resultDTO.getData()).getNameCn();
            }
            return userId + "";
        }
        catch (Exception e) {
            LOGGER.error("getUserDetailById userId error,userId:{},error:{}", (Object)userId, (Object)e);
            return userId + "";
        }
    }
}

