/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.qqt.platform.common.config.ServerConfiguration;
import com.qqt.platform.common.dto.LogAbstract;
import com.qqt.platform.tool.utils.DateUtil;
import com.qqt.platform.tool.utils.ObjectUtil;
import com.qqt.platform.tool.utils.UrlUtil;
import com.qqt.platform.tool.utils.WebUtil;
import io.github.jhipster.config.JHipsterProperties;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.env.Environment;

public class LogAbstractUtil {
    public static void addRequestInfoToLog(HttpServletRequest request, LogAbstract logAbstract) {
        if (ObjectUtil.isNotEmpty((Object)request)) {
            logAbstract.setRemoteIp(WebUtil.getIP((HttpServletRequest)request));
            logAbstract.setUserAgent(request.getHeader("user-agent"));
            logAbstract.setRequestUri(UrlUtil.getPath((String)request.getRequestURI()));
            logAbstract.setMethod(request.getMethod());
            logAbstract.setToken(request.getHeader("Authorization"));
            logAbstract.setParams(WebUtil.getRequestContent((HttpServletRequest)request));
        }
    }

    public static void addOtherInfoToLog(LogAbstract logAbstract, JHipsterProperties jhipsterProperties, Environment env, ServerConfiguration serverConfiguration) {
        logAbstract.setServiceId(jhipsterProperties.getClientApp().getName());
        logAbstract.setServerHost(serverConfiguration.getHostName());
        logAbstract.setServerIp(serverConfiguration.getIpWithPort());
        logAbstract.setEnv(env.getActiveProfiles()[0]);
        logAbstract.setCreateTime(DateUtil.now());
        if (logAbstract.getParams() == null) {
            logAbstract.setParams("");
        }
    }
}

