/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.event;

import com.qqt.platform.common.config.ServerConfiguration;
import com.qqt.platform.common.dto.LogErrorDTO;
import com.qqt.platform.common.event.ErrorLogEvent;
import com.qqt.platform.common.feign.AdminLogFeignService;
import com.qqt.platform.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ErrorLogListener {
    private static final Logger log = LoggerFactory.getLogger(ErrorLogListener.class);
    private final AdminLogFeignService logService;
    private final ServerConfiguration serverConfiguration;
    private final Environment environment;
    private final JHipsterProperties jHipsterProperties;

    @Async
    @Order
    @EventListener(value={ErrorLogEvent.class})
    public void saveErrorLog(ErrorLogEvent event) {
        Map source = (Map)event.getSource();
        LogErrorDTO logError = (LogErrorDTO)source.get("info");
        LogAbstractUtil.addOtherInfoToLog(logError, this.jHipsterProperties, this.environment, this.serverConfiguration);
        this.logService.saveErrorLog(logError);
    }

    public ErrorLogListener(AdminLogFeignService logService, ServerConfiguration serverConfiguration, Environment environment, JHipsterProperties jHipsterProperties) {
        this.logService = logService;
        this.serverConfiguration = serverConfiguration;
        this.environment = environment;
        this.jHipsterProperties = jHipsterProperties;
    }
}

