/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.config;

import com.qqt.platform.tool.utils.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.SnappyCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.redisson.hibernate.RedissonRegionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class QQTRedissonRegionFactory
extends RedissonRegionFactory {
    private final Logger log = LoggerFactory.getLogger(QQTRedissonRegionFactory.class);
    private final String path = File.separator + "var" + File.separator + "temp";

    protected RedissonClient createRedissonClient(Map properties) {
        Config config = new Config();
        String env = (String)properties.get("hibernate.cache.active");
        if (StringUtil.isBlank((CharSequence)env)) {
            throw new CacheException("hibernate.cache.active is null");
        }
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("config" + File.separator + "application-" + env + ".yml");
        this.writeYmlFile(resourceAsStream, env);
        YamlPropertiesFactoryBean yaml = new YamlPropertiesFactoryBean();
        FileSystemResource fileSystemResource = new FileSystemResource(new File(this.path + File.separator + "application-" + env + ".yml"));
        yaml.setResources(new Resource[]{fileSystemResource});
        Properties yamlObject = yaml.getObject();
        String host = yamlObject.getProperty("spring.redis.host", "127.0.0.1");
        String port = yamlObject.getProperty("spring.redis.port", "6379");
        String password = yamlObject.getProperty("spring.redis.password", "");
        Integer database = Integer.parseInt(yamlObject.getProperty("spring.redis.database", "0"));
        Integer timeout = Integer.parseInt(yamlObject.getProperty("spring.redis.timeout", "60000"));
        String server = "redis://" + host + ":" + port;
        ((SingleServerConfig)config.useSingleServer().setAddress(server).setPassword(password)).setDatabase(database.intValue()).setConnectTimeout(timeout.intValue());
        config.setCodec((Codec)new SnappyCodec());
        if (config == null) {
            throw new CacheException("Unable to locate Redisson configuration");
        }
        return Redisson.create((Config)config);
    }

    private void writeYmlFile(InputStream resourceAsStream, String profile) {
        BufferedReader bufferedReader = null;
        FileOutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            File file = new File(this.path + File.separator + "application-" + profile + ".yml");
            if (!file.exists()) {
                file.mkdirs();
            }
            this.log.info("application profile:{}", (Object)profile);
            bufferedReader = new BufferedReader(new InputStreamReader(resourceAsStream));
            outputStream = new FileOutputStream(this.path + File.separator + "application-" + profile + ".yml");
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
            String len = null;
            while ((len = bufferedReader.readLine()) != null) {
                bufferedWriter.write(len);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
        }
        catch (IOException e) {
            this.log.error("Unable to read YML:{}", (Throwable)e);
            throw new CacheException("Unable to read YML");
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

