/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.event;

import com.qqt.platform.common.config.ServerConfiguration;
import com.qqt.platform.common.dto.LogUsualDTO;
import com.qqt.platform.common.event.UsualLogEvent;
import com.qqt.platform.common.feign.AdminLogFeignService;
import com.qqt.platform.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class UsualLogListener {
    private static final Logger log = LoggerFactory.getLogger(UsualLogListener.class);
    private final AdminLogFeignService logService;
    private final ServerConfiguration serverConfiguration;
    private final Environment environment;
    private final JHipsterProperties jHipsterProperties;

    @Async
    @Order
    @EventListener(value={UsualLogEvent.class})
    public void saveUsualLog(UsualLogEvent event) {
        Map source = (Map)event.getSource();
        LogUsualDTO logUsualDTO = (LogUsualDTO)source.get("info");
        LogAbstractUtil.addOtherInfoToLog(logUsualDTO, this.jHipsterProperties, this.environment, this.serverConfiguration);
        this.logService.saveUsualLog(logUsualDTO);
    }

    public UsualLogListener(AdminLogFeignService logService, ServerConfiguration serverConfiguration, Environment environment, JHipsterProperties jHipsterProperties) {
        this.logService = logService;
        this.serverConfiguration = serverConfiguration;
        this.environment = environment;
        this.jHipsterProperties = jHipsterProperties;
    }
}

