/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.config;

import com.qqt.platform.common.dto.SnowflakeDTO;
import com.qqt.platform.common.utils.SnowflakeIdWorker;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.scheduling.annotation.Scheduled;

@Configuration
public class SnowflakeInitiator {
    private Logger logger = LoggerFactory.getLogger(SnowflakeInitiator.class);
    public static SnowflakeDTO snowflakeVo;
    private static String snowflakeRedisKey;
    private static String prefixRedisKey;
    private static boolean stopTrying;
    private static long LockExpire;
    @Resource
    private RedisTemplate redisTemplate;

    @Bean
    public SnowflakeIdWorker init() throws InterruptedException {
        if (stopTrying) {
            this.logger.info("snowflake\u5f3a\u5236\u7ed3\u675f\u751f\u6210key\uff0ckey = {}", (Object)snowflakeRedisKey);
            SnowflakeIdWorker worker = new SnowflakeIdWorker(snowflakeVo.getWorkerId(), snowflakeVo.getDataCenterId());
            return worker;
        }
        if (this.tryInit()) {
            this.logger.info("snowflake\u7ed3\u675f\u751f\u6210key\uff0ckey = {}", (Object)snowflakeRedisKey);
            SnowflakeIdWorker worker = new SnowflakeIdWorker(snowflakeVo.getWorkerId(), snowflakeVo.getDataCenterId());
            return worker;
        }
        Thread.sleep(10L);
        return this.init();
    }

    public boolean tryInit() {
        snowflakeVo = this.nextKey(snowflakeVo);
        snowflakeRedisKey = prefixRedisKey + "_" + snowflakeVo.getDataCenterId() + "_" + snowflakeVo.getWorkerId();
        this.redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        if (!this.redisTemplate.hasKey((Object)snowflakeRedisKey).booleanValue() && this.redisTemplate.opsForValue().setIfAbsent((Object)snowflakeRedisKey, (Object)1, LockExpire, TimeUnit.MINUTES).booleanValue()) {
            this.logger.info("\u6210\u529f\u62a2\u5360\u9501\uff0cConstants.snowflakeVo = {}", (Object)snowflakeRedisKey);
            return true;
        }
        return false;
    }

    private SnowflakeDTO nextKey(SnowflakeDTO snowflakeVo) {
        if (snowflakeVo == null) {
            return new SnowflakeDTO(1L, 1L);
        }
        if (snowflakeVo.getWorkerId() < 31L) {
            snowflakeVo.setWorkerId(snowflakeVo.getWorkerId() + 1L);
        } else if (snowflakeVo.getDataCenterId() < 31L) {
            snowflakeVo.setDataCenterId(snowflakeVo.getDataCenterId() + 1L);
            snowflakeVo.setWorkerId(1L);
        } else {
            snowflakeVo.setDataCenterId(1L);
            snowflakeVo.setWorkerId(1L);
            stopTrying = true;
        }
        return snowflakeVo;
    }

    @PreDestroy
    public void destroy() {
        Boolean deleteFlag = this.redisTemplate.delete((Object)snowflakeRedisKey);
        this.logger.info("\u6e05\u7406\u5f53\u524d\u8282\u70b9\u7684SnowflakeRedisKey: {}\uff0c\u6e05\u7406\u7ed3\u679c\u4e3a\uff1a{}", (Object)snowflakeRedisKey, (Object)deleteFlag);
    }

    public void resetExpire() {
        Boolean expireFlag = this.redisTemplate.expire((Object)snowflakeRedisKey, LockExpire, TimeUnit.MINUTES);
        this.logger.info("\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u91cd\u7f6esnowflakeRedisKey\u8fc7\u671f\u65f6\u95f4 resetExpire() redisKey = {}\uff0c\u8bbe\u7f6e\u7ed3\u679c\u4e3a\uff1a{}", (Object)snowflakeRedisKey, (Object)expireFlag);
    }

    @Scheduled(fixedDelay=900000L)
    private void snowflakeInitiator_ResetExpire() {
        this.resetExpire();
    }

    static {
        prefixRedisKey = "SnowflakeRedisKey";
        stopTrying = false;
        LockExpire = 20L;
    }
}

