/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.event;

import com.alibaba.fastjson.JSON;
import com.qqt.platform.common.config.KafkaMessage;
import com.qqt.platform.common.config.ServerConfiguration;
import com.qqt.platform.common.dto.DataOperateLogDTO;
import com.qqt.platform.common.event.DataOperateLogEvent;
import com.qqt.platform.common.utils.KafkaProduceUtil;
import com.qqt.platform.common.utils.LogAbstractUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class DataOperateLogListener {
    private static final Logger log = LoggerFactory.getLogger(DataOperateLogListener.class);
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Autowired
    private ServerConfiguration serverConfiguration;
    @Autowired
    private JHipsterProperties jHipsterProperties;
    @Value(value="${spring.profiles.active}")
    private String env;

    @Async
    @Order
    @EventListener(value={DataOperateLogEvent.class})
    public void saveDateOperateLog(DataOperateLogEvent event) {
        Map source = (Map)event.getSource();
        DataOperateLogDTO dto = (DataOperateLogDTO)source.get("info");
        dto.setEnv(this.env);
        LogAbstractUtil.addOtherInfoToLog(dto, this.jHipsterProperties, this.serverConfiguration);
        KafkaMessage kafkaMessage = new KafkaMessage();
        kafkaMessage.setChannel("platform_data_operate_log_" + this.env);
        kafkaMessage.setMessage(JSON.parseObject((String)JSON.toJSONString((Object)dto)));
        this.kafkaProduceUtil.sendMessage(kafkaMessage);
    }
}

