/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import cn.hutool.core.util.ObjectUtil;
import com.qqt.platform.common.config.ServerConfiguration;
import com.qqt.platform.common.dto.LogAbstract;
import com.qqt.platform.common.utils.UrlUtil;
import com.qqt.platform.common.utils.WebUtil;
import io.github.jhipster.config.JHipsterProperties;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class LogAbstractUtil {
    public static void addRequestInfoToLog(HttpServletRequest request, LogAbstract logAbstract) {
        if (ObjectUtil.isNotEmpty((Object)request)) {
            logAbstract.setRemoteIp(WebUtil.getIP(request));
            logAbstract.setUserAgent(request.getHeader("user-agent"));
            logAbstract.setRequestUri(UrlUtil.getPath(request.getRequestURI()));
            logAbstract.setMethod(request.getMethod());
            logAbstract.setParams(WebUtil.getRequestContent(request));
        }
    }

    public static void addOtherInfoToLog(LogAbstract logAbstract, JHipsterProperties jhipsterProperties, ServerConfiguration serverConfiguration) {
        logAbstract.setServiceId(jhipsterProperties.getClientApp().getName());
        logAbstract.setServerHost(serverConfiguration.getHostName());
        logAbstract.setServerIp(serverConfiguration.getIpWithPort());
        logAbstract.setCreateTime(new Date());
        if (logAbstract.getParams() == null) {
            logAbstract.setParams("");
        }
    }
}

