/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.facade.mapper;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.qqt.platform.common.domain.AbstractCompanyEntity;
import com.qqt.platform.common.domain.IAuditingEntity;
import com.qqt.platform.common.dto.CompanyDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.UserDTO;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.service.dto.AbstractAuditingDTO;
import com.qqt.platform.common.utils.JCacheManagerUtils;
import java.util.List;
import java.util.Set;
import javax.cache.Cache;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.AfterMapping;
import org.mapstruct.MappingTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;

public abstract class AuditingDTOMapper<DTO extends AbstractAuditingDTO, Entity extends IAuditingEntity> {
    private static final Logger logger = LoggerFactory.getLogger(AuditingDTOMapper.class);
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    JCacheManagerUtils jCacheManagerUtils;

    public abstract Entity toEntity(DTO var1);

    @AfterMapping
    protected void fillAuditing(Entity auditingEntity, @MappingTarget DTO auditingDTO) {
        block42: {
            ObjectMapper objectMapper;
            block41: {
                ResultDTO resultDTO;
                ResponseEntity<ResultDTO<UserDTO>> userEntity;
                UserDTO userDTO;
                Cache<Object, Object> userDataCache;
                String userId;
                block40: {
                    try {
                        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{auditingEntity.getCreatedBy()})) break block40;
                        userId = auditingEntity.getCreatedBy();
                        userDataCache = this.jCacheManagerUtils.getCacheByKey("com.qqt.platform.admin.domain.User");
                        objectMapper = new ObjectMapper();
                        userDTO = null;
                        if (userDataCache != null) {
                            objectMapper.registerModule((Module)new JavaTimeModule());
                            userDTO = (UserDTO)objectMapper.convertValue(userDataCache.get((Object)userId), UserDTO.class);
                        }
                        if (userDTO != null) {
                            ((AbstractAuditingDTO)auditingDTO).setCreatedName(userDTO.getNameCn());
                            break block40;
                        }
                        try {
                            if (StringUtils.isNumeric((CharSequence)userId)) {
                                userEntity = this.adminFeignService.getUserById(Long.parseLong(userId));
                                if (userEntity != null && userEntity.getBody() != null && ((ResultDTO)userEntity.getBody()).getData() != null) {
                                    resultDTO = (ResultDTO)userEntity.getBody();
                                    if (resultDTO.getData() != null) {
                                        userDTO = (UserDTO)resultDTO.getData();
                                    }
                                } else {
                                    userDTO = new UserDTO();
                                    userDTO.setNameCn(userId);
                                }
                            } else {
                                userDTO = new UserDTO();
                                userDTO.setNameCn(userId);
                            }
                        }
                        catch (Exception e) {
                            logger.error("getUserDetailByCode CreatedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
                            userDTO = new UserDTO();
                            userDTO.setNameCn(userId);
                        }
                        if (userDTO != null) {
                            ((AbstractAuditingDTO)auditingDTO).setCreatedName(userDTO.getNameCn());
                        }
                        if (userDataCache != null) {
                            userDataCache.put((Object)userId, (Object)userDTO);
                        }
                    }
                    catch (Exception e) {
                        logger.error("getUserDetailByCode CreatedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
                    }
                }
                try {
                    if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{auditingEntity.getLastModifiedBy()})) break block41;
                    userId = auditingEntity.getLastModifiedBy();
                    userDataCache = this.jCacheManagerUtils.getCacheByKey("com.qqt.platform.admin.domain.User");
                    objectMapper = new ObjectMapper();
                    userDTO = null;
                    if (userDataCache != null) {
                        objectMapper.registerModule((Module)new JavaTimeModule());
                        userDTO = (UserDTO)objectMapper.convertValue(userDataCache.get((Object)userId), UserDTO.class);
                    }
                    if (userDTO != null) {
                        ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(userDTO.getNameCn());
                        break block41;
                    }
                    try {
                        if (StringUtils.isNumeric((CharSequence)userId)) {
                            userEntity = this.adminFeignService.getUserById(Long.parseLong(userId));
                            if (userEntity != null && userEntity.getBody() != null && ((ResultDTO)userEntity.getBody()).getData() != null) {
                                resultDTO = (ResultDTO)userEntity.getBody();
                                if (resultDTO.getData() != null) {
                                    userDTO = (UserDTO)resultDTO.getData();
                                }
                            } else {
                                userDTO = new UserDTO();
                                userDTO.setNameCn(userId);
                            }
                        } else {
                            userDTO = new UserDTO();
                            userDTO.setNameCn(userId);
                        }
                    }
                    catch (Exception e) {
                        logger.error("getUserDetailByCode CreatedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
                        userDTO = new UserDTO();
                        userDTO.setNameCn(userId);
                    }
                    if (userDTO != null) {
                        ((AbstractAuditingDTO)auditingDTO).setLastModifiedName(userDTO.getNameCn());
                    }
                    if (userDataCache != null) {
                        userDataCache.put((Object)userId, (Object)userDTO);
                    }
                }
                catch (Exception e) {
                    logger.error("getUserDetailByCode LastModifiedBy error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
                }
            }
            Long companyId = null;
            if (auditingEntity instanceof AbstractCompanyEntity) {
                AbstractCompanyEntity companyEntity = (AbstractCompanyEntity)auditingEntity;
                if (companyEntity.getCompanyId() != null && companyEntity.getCompanyId() > 0L) {
                    companyId = companyEntity.getCompanyId();
                }
            } else if (null != ((AbstractAuditingDTO)auditingDTO).getCompanyId()) {
                companyId = ((AbstractAuditingDTO)auditingDTO).getCompanyId();
            }
            if (null != companyId) {
                try {
                    Cache<Object, Object> companyDataCache = this.jCacheManagerUtils.getCacheByKey("com.qqt.platform.admin.domain.Company");
                    objectMapper = new ObjectMapper();
                    CompanyDO companyDO = null;
                    if (companyDataCache != null) {
                        objectMapper.registerModule((Module)new JavaTimeModule());
                        companyDO = (CompanyDO)objectMapper.convertValue(companyDataCache.get((Object)companyId), CompanyDO.class);
                    }
                    if (companyDO != null) {
                        ((AbstractAuditingDTO)auditingDTO).setCompanyId(companyDO.getId());
                        ((AbstractAuditingDTO)auditingDTO).setCompanyCode(companyDO.getCode());
                        ((AbstractAuditingDTO)auditingDTO).setCompanyName(companyDO.getName());
                        break block42;
                    }
                    try {
                        ResultDTO resultDO;
                        ResponseEntity<ResultDTO<CompanyDO>> companyDOEntity = this.adminFeignService.getCompanyById(companyId, new String[0]);
                        if (companyDOEntity != null && companyDOEntity.getBody() != null && (resultDO = (ResultDTO)companyDOEntity.getBody()).getData() != null) {
                            CompanyDO companyDOData = (CompanyDO)resultDO.getData();
                            companyDO = new CompanyDO();
                            companyDO.setId(companyDOData.getId());
                            companyDO.setCode(companyDOData.getCode());
                            companyDO.setName(companyDOData.getName());
                            logger.debug("companyDO,Code:{},Name:{}", (Object)companyDO.getCode(), (Object)companyDO.getName());
                        }
                    }
                    catch (Exception e) {
                        logger.error("getCompanyById error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
                        companyDO = new CompanyDO();
                        companyDO.setId(companyId);
                        companyDO.setCode(String.valueOf(companyId));
                        companyDO.setName(String.valueOf(companyId));
                    }
                    if (companyDO != null) {
                        ((AbstractAuditingDTO)auditingDTO).setCompanyId(companyDO.getId());
                        ((AbstractAuditingDTO)auditingDTO).setCompanyCode(companyDO.getCode());
                        ((AbstractAuditingDTO)auditingDTO).setCompanyName(companyDO.getName());
                    }
                    if (companyDataCache != null) {
                        companyDataCache.put((Object)companyId, (Object)companyDO);
                    }
                }
                catch (Exception e) {
                    logger.error("getCompanyById error,auditingDTO:{},error:{}", auditingDTO, (Object)e);
                }
            }
        }
    }

    public abstract DTO toDto(Entity var1);

    public abstract List<Entity> toEntity(List<DTO> var1);

    public abstract List<DTO> toDto(List<Entity> var1);

    public abstract List<DTO> toDto(Set<Entity> var1);
}

