/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.qqt.platform.common.utils.LocalRedissonRegionFactory;
import java.util.Map;
import org.redisson.api.RMapCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EntityCacheUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger(EntityCacheUtils.class);

    public Map getFromCache(Class clazz, Long id) {
        return this.getFromCache(clazz.getName(), id);
    }

    public Map getFromCache(String className, Long id) {
        try {
            Object obj;
            RMapCache rMapCache = LocalRedissonRegionFactory.getMapCache(className);
            if (rMapCache != null && (obj = rMapCache.get((Object)id)) != null) {
                Map map = (Map)obj;
                map.put("id", id);
                return map;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("get from cache error,className:" + className + ",id:" + id, (Throwable)e);
            return null;
        }
    }
}

