/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.aop.interceptor;

import com.qqt.platform.common.dto.OperateLogDTO;
import com.qqt.platform.common.event.OperateLogPublisher;
import com.qqt.platform.common.security.SecurityUtils;
import java.io.Serializable;
import java.util.Optional;
import org.hibernate.CallbackException;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteInterceptor
extends EmptyInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DeleteInterceptor.class);

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        log.debug("\u8fdb\u5165\u62e6\u622a\u5668:{},{},{},{},{}", new Object[]{entity, id, state, propertyNames, types});
        String login = null;
        Optional<String> optional = SecurityUtils.getCurrentUserLogin();
        if (optional.isPresent()) {
            login = optional.get();
        }
        log.info("getCurrentUserLogin:{}", (Object)login);
        this.sendLogMessage("onDelete", id.toString(), login, entity.toString());
    }

    public void onCollectionRemove(Object collection, Serializable key) throws CallbackException {
        log.debug("\u8fdb\u5165\u62e6\u622a\u5668:{},{}", collection, (Object)key);
        String login = null;
        Optional<String> optional = SecurityUtils.getCurrentUserLogin();
        if (optional.isPresent()) {
            login = optional.get();
        }
        log.info("getCurrentUserLogin:{}", (Object)login);
        this.sendLogMessage("onDelete", key.toString(), login, collection.toString());
    }

    private void sendLogMessage(String operateType, String params, String login, String content) {
        try {
            OperateLogDTO operationLog = new OperateLogDTO();
            operationLog.setLogin(login);
            operationLog.setParams(params);
            operationLog.setOperateType(operateType);
            operationLog.setContent(content);
            OperateLogPublisher.publishEvent(operationLog);
        }
        catch (Exception e) {
            log.error("Save operationLogService error:{}", (Throwable)e);
        }
    }
}

